<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeRouteFilterElement StructType
 * @subpackage Structs
 */
class RImeRouteFilterElement extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The elementType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $elementType;
    /**
     * The imeRouteFilterGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $imeRouteFilterGroupName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeRouteFilterElement
     * @uses RImeRouteFilterElement::setName()
     * @uses RImeRouteFilterElement::setDescription()
     * @uses RImeRouteFilterElement::setElementType()
     * @uses RImeRouteFilterElement::setImeRouteFilterGroupName()
     * @uses RImeRouteFilterElement::setUuid()
     * @param string $name
     * @param string $description
     * @param string $elementType
     * @param \StructType\XFkType $imeRouteFilterGroupName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $elementType = null, \StructType\XFkType $imeRouteFilterGroupName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setElementType($elementType)
            ->setImeRouteFilterGroupName($imeRouteFilterGroupName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RImeRouteFilterElement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RImeRouteFilterElement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get elementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->elementType;
    }
    /**
     * Set elementType value
     * @uses \EnumType\XViprFilterElement::valueIsValid()
     * @uses \EnumType\XViprFilterElement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elementType
     * @return \StructType\RImeRouteFilterElement
     */
    public function setElementType($elementType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XViprFilterElement::valueIsValid($elementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XViprFilterElement', is_array($elementType) ? implode(', ', $elementType) : var_export($elementType, true), implode(', ', \EnumType\XViprFilterElement::getValidValues())), __LINE__);
        }
        $this->elementType = $elementType;
        return $this;
    }
    /**
     * Get imeRouteFilterGroupName value
     * @return \StructType\XFkType|null
     */
    public function getImeRouteFilterGroupName()
    {
        return $this->imeRouteFilterGroupName;
    }
    /**
     * Set imeRouteFilterGroupName value
     * @param \StructType\XFkType $imeRouteFilterGroupName
     * @return \StructType\RImeRouteFilterElement
     */
    public function setImeRouteFilterGroupName(\StructType\XFkType $imeRouteFilterGroupName = null)
    {
        $this->imeRouteFilterGroupName = $imeRouteFilterGroupName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RImeRouteFilterElement
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
