<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeEnrolledPatternGroup StructType
 * @subpackage Structs
 */
class RImeEnrolledPatternGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fallbackProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $fallbackProfileName;
    /**
     * The isPatternAllAlias
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPatternAllAlias;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeEnrolledPatternGroup
     * @uses RImeEnrolledPatternGroup::setName()
     * @uses RImeEnrolledPatternGroup::setDescription()
     * @uses RImeEnrolledPatternGroup::setFallbackProfileName()
     * @uses RImeEnrolledPatternGroup::setIsPatternAllAlias()
     * @uses RImeEnrolledPatternGroup::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $fallbackProfileName
     * @param string $isPatternAllAlias
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $fallbackProfileName = null, $isPatternAllAlias = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFallbackProfileName($fallbackProfileName)
            ->setIsPatternAllAlias($isPatternAllAlias)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fallbackProfileName value
     * @return \StructType\XFkType|null
     */
    public function getFallbackProfileName()
    {
        return $this->fallbackProfileName;
    }
    /**
     * Set fallbackProfileName value
     * @param \StructType\XFkType $fallbackProfileName
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setFallbackProfileName(\StructType\XFkType $fallbackProfileName = null)
    {
        $this->fallbackProfileName = $fallbackProfileName;
        return $this;
    }
    /**
     * Get isPatternAllAlias value
     * @return string|null
     */
    public function getIsPatternAllAlias()
    {
        return $this->isPatternAllAlias;
    }
    /**
     * Set isPatternAllAlias value
     * @param string $isPatternAllAlias
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setIsPatternAllAlias($isPatternAllAlias = null)
    {
        // validation for constraint: string
        if (!is_null($isPatternAllAlias) && !is_string($isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPatternAllAlias, true), gettype($isPatternAllAlias)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isPatternAllAlias) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isPatternAllAlias, true)), __LINE__);
        }
        $this->isPatternAllAlias = $isPatternAllAlias;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
