<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeClient StructType
 * @subpackage Structs
 */
class RImeClient extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The domain
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $primaryImeServerName;
    /**
     * The secondaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $firewallName;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The ccmExternalIpMaps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CcmExternalIpMaps
     */
    public $ccmExternalIpMaps;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeClient
     * @uses RImeClient::setName()
     * @uses RImeClient::setDescription()
     * @uses RImeClient::setDomain()
     * @uses RImeClient::setIsActivated()
     * @uses RImeClient::setSipTrunkName()
     * @uses RImeClient::setPrimaryImeServerName()
     * @uses RImeClient::setSecondaryImeServerName()
     * @uses RImeClient::setLearnedRouteFilterGroupName()
     * @uses RImeClient::setExclusionNumberGroupName()
     * @uses RImeClient::setFirewallName()
     * @uses RImeClient::setMembers()
     * @uses RImeClient::setCcmExternalIpMaps()
     * @uses RImeClient::setUuid()
     * @param string $name
     * @param string $description
     * @param string $domain
     * @param string $isActivated
     * @param \StructType\XFkType $sipTrunkName
     * @param \StructType\XFkType $primaryImeServerName
     * @param \StructType\XFkType $secondaryImeServerName
     * @param \StructType\XFkType $learnedRouteFilterGroupName
     * @param \StructType\XFkType $exclusionNumberGroupName
     * @param \StructType\XFkType $firewallName
     * @param \StructType\Members $members
     * @param \StructType\CcmExternalIpMaps $ccmExternalIpMaps
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $domain = null, $isActivated = null, \StructType\XFkType $sipTrunkName = null, \StructType\XFkType $primaryImeServerName = null, \StructType\XFkType $secondaryImeServerName = null, \StructType\XFkType $learnedRouteFilterGroupName = null, \StructType\XFkType $exclusionNumberGroupName = null, \StructType\XFkType $firewallName = null, \StructType\Members $members = null, \StructType\CcmExternalIpMaps $ccmExternalIpMaps = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDomain($domain)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setMembers($members)
            ->setCcmExternalIpMaps($ccmExternalIpMaps)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RImeClient
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RImeClient
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\RImeClient
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($domain) && mb_strlen($domain) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\RImeClient
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\RImeClient
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return \StructType\XFkType|null
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param \StructType\XFkType $primaryImeServerName
     * @return \StructType\RImeClient
     */
    public function setPrimaryImeServerName(\StructType\XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * @return \StructType\XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return $this->secondaryImeServerName;
    }
    /**
     * Set secondaryImeServerName value
     * @param \StructType\XFkType $secondaryImeServerName
     * @return \StructType\RImeClient
     */
    public function setSecondaryImeServerName(\StructType\XFkType $secondaryImeServerName = null)
    {
        $this->secondaryImeServerName = $secondaryImeServerName;
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * @return \StructType\XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return $this->learnedRouteFilterGroupName;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * @param \StructType\XFkType $learnedRouteFilterGroupName
     * @return \StructType\RImeClient
     */
    public function setLearnedRouteFilterGroupName(\StructType\XFkType $learnedRouteFilterGroupName = null)
    {
        $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * @return \StructType\XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return $this->exclusionNumberGroupName;
    }
    /**
     * Set exclusionNumberGroupName value
     * @param \StructType\XFkType $exclusionNumberGroupName
     * @return \StructType\RImeClient
     */
    public function setExclusionNumberGroupName(\StructType\XFkType $exclusionNumberGroupName = null)
    {
        $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        return $this;
    }
    /**
     * Get firewallName value
     * @return \StructType\XFkType|null
     */
    public function getFirewallName()
    {
        return $this->firewallName;
    }
    /**
     * Set firewallName value
     * @param \StructType\XFkType $firewallName
     * @return \StructType\RImeClient
     */
    public function setFirewallName(\StructType\XFkType $firewallName = null)
    {
        $this->firewallName = $firewallName;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\RImeClient
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get ccmExternalIpMaps value
     * @return \StructType\CcmExternalIpMaps|null
     */
    public function getCcmExternalIpMaps()
    {
        return $this->ccmExternalIpMaps;
    }
    /**
     * Set ccmExternalIpMaps value
     * @param \StructType\CcmExternalIpMaps $ccmExternalIpMaps
     * @return \StructType\RImeClient
     */
    public function setCcmExternalIpMaps(\StructType\CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this->ccmExternalIpMaps = $ccmExternalIpMaps;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RImeClient
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
