<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGeoLocationPolicy StructType
 * @subpackage Structs
 */
class RGeoLocationPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The nationalSubDivision
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalSubDivision;
    /**
     * The district
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $district;
    /**
     * The communityName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $communityName;
    /**
     * The cityDivision
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cityDivision;
    /**
     * The neighbourhood
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $neighbourhood;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The leadingStreetDirection
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $leadingStreetDirection;
    /**
     * The trailingStreetSuffix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trailingStreetSuffix;
    /**
     * The streetSuffix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $streetSuffix;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseNumberSuffix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumberSuffix;
    /**
     * The landmark
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $landmark;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $floor;
    /**
     * The occupantName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $occupantName;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The relatedPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedPolicies
     */
    public $relatedPolicies;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RGeoLocationPolicy
     * @uses RGeoLocationPolicy::setName()
     * @uses RGeoLocationPolicy::setCountry()
     * @uses RGeoLocationPolicy::setDescription()
     * @uses RGeoLocationPolicy::setNationalSubDivision()
     * @uses RGeoLocationPolicy::setDistrict()
     * @uses RGeoLocationPolicy::setCommunityName()
     * @uses RGeoLocationPolicy::setCityDivision()
     * @uses RGeoLocationPolicy::setNeighbourhood()
     * @uses RGeoLocationPolicy::setStreet()
     * @uses RGeoLocationPolicy::setLeadingStreetDirection()
     * @uses RGeoLocationPolicy::setTrailingStreetSuffix()
     * @uses RGeoLocationPolicy::setStreetSuffix()
     * @uses RGeoLocationPolicy::setHouseNumber()
     * @uses RGeoLocationPolicy::setHouseNumberSuffix()
     * @uses RGeoLocationPolicy::setLandmark()
     * @uses RGeoLocationPolicy::setLocation()
     * @uses RGeoLocationPolicy::setFloor()
     * @uses RGeoLocationPolicy::setOccupantName()
     * @uses RGeoLocationPolicy::setPostalCode()
     * @uses RGeoLocationPolicy::setRelatedPolicies()
     * @uses RGeoLocationPolicy::setUuid()
     * @param string $name
     * @param string $country
     * @param string $description
     * @param string $nationalSubDivision
     * @param string $district
     * @param string $communityName
     * @param string $cityDivision
     * @param string $neighbourhood
     * @param string $street
     * @param string $leadingStreetDirection
     * @param string $trailingStreetSuffix
     * @param string $streetSuffix
     * @param string $houseNumber
     * @param string $houseNumberSuffix
     * @param string $landmark
     * @param string $location
     * @param string $floor
     * @param string $occupantName
     * @param string $postalCode
     * @param \StructType\RelatedPolicies $relatedPolicies
     * @param string $uuid
     */
    public function __construct($name = null, $country = null, $description = null, $nationalSubDivision = null, $district = null, $communityName = null, $cityDivision = null, $neighbourhood = null, $street = null, $leadingStreetDirection = null, $trailingStreetSuffix = null, $streetSuffix = null, $houseNumber = null, $houseNumberSuffix = null, $landmark = null, $location = null, $floor = null, $occupantName = null, $postalCode = null, \StructType\RelatedPolicies $relatedPolicies = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setCountry($country)
            ->setDescription($description)
            ->setNationalSubDivision($nationalSubDivision)
            ->setDistrict($district)
            ->setCommunityName($communityName)
            ->setCityDivision($cityDivision)
            ->setNeighbourhood($neighbourhood)
            ->setStreet($street)
            ->setLeadingStreetDirection($leadingStreetDirection)
            ->setTrailingStreetSuffix($trailingStreetSuffix)
            ->setStreetSuffix($streetSuffix)
            ->setHouseNumber($houseNumber)
            ->setHouseNumberSuffix($houseNumberSuffix)
            ->setLandmark($landmark)
            ->setLocation($location)
            ->setFloor($floor)
            ->setOccupantName($occupantName)
            ->setPostalCode($postalCode)
            ->setRelatedPolicies($relatedPolicies)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RGeoLocationPolicy
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\RGeoLocationPolicy
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RGeoLocationPolicy
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nationalSubDivision value
     * @return string|null
     */
    public function getNationalSubDivision()
    {
        return $this->nationalSubDivision;
    }
    /**
     * Set nationalSubDivision value
     * @param string $nationalSubDivision
     * @return \StructType\RGeoLocationPolicy
     */
    public function setNationalSubDivision($nationalSubDivision = null)
    {
        // validation for constraint: string
        if (!is_null($nationalSubDivision) && !is_string($nationalSubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalSubDivision, true), gettype($nationalSubDivision)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($nationalSubDivision) && mb_strlen($nationalSubDivision) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($nationalSubDivision)), __LINE__);
        }
        $this->nationalSubDivision = $nationalSubDivision;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\RGeoLocationPolicy
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($district) && mb_strlen($district) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return \StructType\RGeoLocationPolicy
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communityName, true), gettype($communityName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($communityName) && mb_strlen($communityName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
    /**
     * Get cityDivision value
     * @return string|null
     */
    public function getCityDivision()
    {
        return $this->cityDivision;
    }
    /**
     * Set cityDivision value
     * @param string $cityDivision
     * @return \StructType\RGeoLocationPolicy
     */
    public function setCityDivision($cityDivision = null)
    {
        // validation for constraint: string
        if (!is_null($cityDivision) && !is_string($cityDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityDivision, true), gettype($cityDivision)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cityDivision) && mb_strlen($cityDivision) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($cityDivision)), __LINE__);
        }
        $this->cityDivision = $cityDivision;
        return $this;
    }
    /**
     * Get neighbourhood value
     * @return string|null
     */
    public function getNeighbourhood()
    {
        return $this->neighbourhood;
    }
    /**
     * Set neighbourhood value
     * @param string $neighbourhood
     * @return \StructType\RGeoLocationPolicy
     */
    public function setNeighbourhood($neighbourhood = null)
    {
        // validation for constraint: string
        if (!is_null($neighbourhood) && !is_string($neighbourhood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($neighbourhood, true), gettype($neighbourhood)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($neighbourhood) && mb_strlen($neighbourhood) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($neighbourhood)), __LINE__);
        }
        $this->neighbourhood = $neighbourhood;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\RGeoLocationPolicy
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($street) && mb_strlen($street) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get leadingStreetDirection value
     * @return string|null
     */
    public function getLeadingStreetDirection()
    {
        return $this->leadingStreetDirection;
    }
    /**
     * Set leadingStreetDirection value
     * @param string $leadingStreetDirection
     * @return \StructType\RGeoLocationPolicy
     */
    public function setLeadingStreetDirection($leadingStreetDirection = null)
    {
        // validation for constraint: string
        if (!is_null($leadingStreetDirection) && !is_string($leadingStreetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadingStreetDirection, true), gettype($leadingStreetDirection)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($leadingStreetDirection) && mb_strlen($leadingStreetDirection) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($leadingStreetDirection)), __LINE__);
        }
        $this->leadingStreetDirection = $leadingStreetDirection;
        return $this;
    }
    /**
     * Get trailingStreetSuffix value
     * @return string|null
     */
    public function getTrailingStreetSuffix()
    {
        return $this->trailingStreetSuffix;
    }
    /**
     * Set trailingStreetSuffix value
     * @param string $trailingStreetSuffix
     * @return \StructType\RGeoLocationPolicy
     */
    public function setTrailingStreetSuffix($trailingStreetSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($trailingStreetSuffix) && !is_string($trailingStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailingStreetSuffix, true), gettype($trailingStreetSuffix)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($trailingStreetSuffix) && mb_strlen($trailingStreetSuffix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($trailingStreetSuffix)), __LINE__);
        }
        $this->trailingStreetSuffix = $trailingStreetSuffix;
        return $this;
    }
    /**
     * Get streetSuffix value
     * @return string|null
     */
    public function getStreetSuffix()
    {
        return $this->streetSuffix;
    }
    /**
     * Set streetSuffix value
     * @param string $streetSuffix
     * @return \StructType\RGeoLocationPolicy
     */
    public function setStreetSuffix($streetSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($streetSuffix) && !is_string($streetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetSuffix, true), gettype($streetSuffix)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($streetSuffix) && mb_strlen($streetSuffix) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($streetSuffix)), __LINE__);
        }
        $this->streetSuffix = $streetSuffix;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \StructType\RGeoLocationPolicy
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseNumberSuffix value
     * @return string|null
     */
    public function getHouseNumberSuffix()
    {
        return $this->houseNumberSuffix;
    }
    /**
     * Set houseNumberSuffix value
     * @param string $houseNumberSuffix
     * @return \StructType\RGeoLocationPolicy
     */
    public function setHouseNumberSuffix($houseNumberSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumberSuffix) && !is_string($houseNumberSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumberSuffix, true), gettype($houseNumberSuffix)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($houseNumberSuffix) && mb_strlen($houseNumberSuffix) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($houseNumberSuffix)), __LINE__);
        }
        $this->houseNumberSuffix = $houseNumberSuffix;
        return $this;
    }
    /**
     * Get landmark value
     * @return string|null
     */
    public function getLandmark()
    {
        return $this->landmark;
    }
    /**
     * Set landmark value
     * @param string $landmark
     * @return \StructType\RGeoLocationPolicy
     */
    public function setLandmark($landmark = null)
    {
        // validation for constraint: string
        if (!is_null($landmark) && !is_string($landmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landmark, true), gettype($landmark)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($landmark) && mb_strlen($landmark) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($landmark)), __LINE__);
        }
        $this->landmark = $landmark;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\RGeoLocationPolicy
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($location) && mb_strlen($location) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \StructType\RGeoLocationPolicy
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($floor) && mb_strlen($floor) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get occupantName value
     * @return string|null
     */
    public function getOccupantName()
    {
        return $this->occupantName;
    }
    /**
     * Set occupantName value
     * @param string $occupantName
     * @return \StructType\RGeoLocationPolicy
     */
    public function setOccupantName($occupantName = null)
    {
        // validation for constraint: string
        if (!is_null($occupantName) && !is_string($occupantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupantName, true), gettype($occupantName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($occupantName) && mb_strlen($occupantName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($occupantName)), __LINE__);
        }
        $this->occupantName = $occupantName;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\RGeoLocationPolicy
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get relatedPolicies value
     * @return \StructType\RelatedPolicies|null
     */
    public function getRelatedPolicies()
    {
        return $this->relatedPolicies;
    }
    /**
     * Set relatedPolicies value
     * @param \StructType\RelatedPolicies $relatedPolicies
     * @return \StructType\RGeoLocationPolicy
     */
    public function setRelatedPolicies(\StructType\RelatedPolicies $relatedPolicies = null)
    {
        $this->relatedPolicies = $relatedPolicies;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RGeoLocationPolicy
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
