<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RExtension StructType
 * @subpackage Structs
 */
class RExtension extends AbstractStructBase
{
    /**
     * The sortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortOrder;
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $pattern;
    /**
     * The routePartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * The linePrimaryUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $linePrimaryUri;
    /**
     * The partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RExtension
     * @uses RExtension::setSortOrder()
     * @uses RExtension::setPattern()
     * @uses RExtension::setRoutePartition()
     * @uses RExtension::setLinePrimaryUri()
     * @uses RExtension::setPartition()
     * @uses RExtension::setUuid()
     * @param string $sortOrder
     * @param \StructType\XFkType $pattern
     * @param string $routePartition
     * @param string $linePrimaryUri
     * @param \StructType\XFkType $partition
     * @param string $uuid
     */
    public function __construct($sortOrder = null, \StructType\XFkType $pattern = null, $routePartition = null, $linePrimaryUri = null, \StructType\XFkType $partition = null, $uuid = null)
    {
        $this
            ->setSortOrder($sortOrder)
            ->setPattern($pattern)
            ->setRoutePartition($routePartition)
            ->setLinePrimaryUri($linePrimaryUri)
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\RExtension
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get pattern value
     * @return \StructType\XFkType|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param \StructType\XFkType $pattern
     * @return \StructType\RExtension
     */
    public function setPattern(\StructType\XFkType $pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param string $routePartition
     * @return \StructType\RExtension
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routePartition, true), gettype($routePartition)), __LINE__);
        }
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get linePrimaryUri value
     * @return string|null
     */
    public function getLinePrimaryUri()
    {
        return $this->linePrimaryUri;
    }
    /**
     * Set linePrimaryUri value
     * @param string $linePrimaryUri
     * @return \StructType\RExtension
     */
    public function setLinePrimaryUri($linePrimaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($linePrimaryUri) && !is_string($linePrimaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linePrimaryUri, true), gettype($linePrimaryUri)), __LINE__);
        }
        $this->linePrimaryUri = $linePrimaryUri;
        return $this;
    }
    /**
     * Get partition value
     * @return \StructType\XFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param \StructType\XFkType $partition
     * @return \StructType\RExtension
     */
    public function setPartition(\StructType\XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RExtension
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
