<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDeviceMobility StructType
 * @subpackage Structs
 */
class RDeviceMobility extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The subNet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subNet;
    /**
     * The subNetMaskSz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subNetMaskSz;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDeviceMobility
     * @uses RDeviceMobility::setName()
     * @uses RDeviceMobility::setSubNet()
     * @uses RDeviceMobility::setSubNetMaskSz()
     * @uses RDeviceMobility::setMembers()
     * @uses RDeviceMobility::setUuid()
     * @param string $name
     * @param string $subNet
     * @param string $subNetMaskSz
     * @param \StructType\Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $subNet = null, $subNetMaskSz = null, \StructType\Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setSubNet($subNet)
            ->setSubNetMaskSz($subNetMaskSz)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RDeviceMobility
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get subNet value
     * @return string|null
     */
    public function getSubNet()
    {
        return $this->subNet;
    }
    /**
     * Set subNet value
     * @param string $subNet
     * @return \StructType\RDeviceMobility
     */
    public function setSubNet($subNet = null)
    {
        // validation for constraint: string
        if (!is_null($subNet) && !is_string($subNet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subNet, true), gettype($subNet)), __LINE__);
        }
        $this->subNet = $subNet;
        return $this;
    }
    /**
     * Get subNetMaskSz value
     * @return string|null
     */
    public function getSubNetMaskSz()
    {
        return $this->subNetMaskSz;
    }
    /**
     * Set subNetMaskSz value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subNetMaskSz
     * @return \StructType\RDeviceMobility
     */
    public function setSubNetMaskSz($subNetMaskSz = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($subNetMaskSz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($subNetMaskSz) ? implode(', ', $subNetMaskSz) : var_export($subNetMaskSz, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subNetMaskSz = $subNetMaskSz;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\RDeviceMobility
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RDeviceMobility
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
