<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcdHostedDN StructType
 * @subpackage Structs
 */
class RCcdHostedDN extends AbstractStructBase
{
    /**
     * The hostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostedPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The CcdHostedDnGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $CcdHostedDnGroup;
    /**
     * The pstnFailoverStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcdHostedDN
     * @uses RCcdHostedDN::setHostedPattern()
     * @uses RCcdHostedDN::setDescription()
     * @uses RCcdHostedDN::setCcdHostedDnGroup()
     * @uses RCcdHostedDN::setPstnFailoverStripDigits()
     * @uses RCcdHostedDN::setPstnFailoverPrependDigits()
     * @uses RCcdHostedDN::setUsePstnFailover()
     * @uses RCcdHostedDN::setUuid()
     * @param string $hostedPattern
     * @param string $description
     * @param \StructType\XFkType $ccdHostedDnGroup
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     * @param string $uuid
     */
    public function __construct($hostedPattern = null, $description = null, \StructType\XFkType $ccdHostedDnGroup = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = null, $uuid = null)
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setDescription($description)
            ->setCcdHostedDnGroup($ccdHostedDnGroup)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover)
            ->setUuid($uuid);
    }
    /**
     * Get hostedPattern value
     * @return string|null
     */
    public function getHostedPattern()
    {
        return $this->hostedPattern;
    }
    /**
     * Set hostedPattern value
     * @param string $hostedPattern
     * @return \StructType\RCcdHostedDN
     */
    public function setHostedPattern($hostedPattern = null)
    {
        // validation for constraint: string
        if (!is_null($hostedPattern) && !is_string($hostedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostedPattern, true), gettype($hostedPattern)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($hostedPattern) && mb_strlen($hostedPattern) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($hostedPattern)), __LINE__);
        }
        $this->hostedPattern = $hostedPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RCcdHostedDN
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get CcdHostedDnGroup value
     * @return \StructType\XFkType|null
     */
    public function getCcdHostedDnGroup()
    {
        return $this->CcdHostedDnGroup;
    }
    /**
     * Set CcdHostedDnGroup value
     * @param \StructType\XFkType $ccdHostedDnGroup
     * @return \StructType\RCcdHostedDN
     */
    public function setCcdHostedDnGroup(\StructType\XFkType $ccdHostedDnGroup = null)
    {
        $this->CcdHostedDnGroup = $ccdHostedDnGroup;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return $this->pstnFailoverStripDigits;
    }
    /**
     * Set pstnFailoverStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailoverStripDigits
     * @return \StructType\RCcdHostedDN
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pstnFailoverStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($pstnFailoverStripDigits) ? implode(', ', $pstnFailoverStripDigits) : var_export($pstnFailoverStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \StructType\RCcdHostedDN
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailoverPrependDigits) && !is_string($pstnFailoverPrependDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailoverPrependDigits, true), gettype($pstnFailoverPrependDigits)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($pstnFailoverPrependDigits) && mb_strlen($pstnFailoverPrependDigits) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($pstnFailoverPrependDigits)), __LINE__);
        }
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \StructType\RCcdHostedDN
     */
    public function setUsePstnFailover($usePstnFailover = null)
    {
        // validation for constraint: string
        if (!is_null($usePstnFailover) && !is_string($usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usePstnFailover, true), gettype($usePstnFailover)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($usePstnFailover) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($usePstnFailover, true)), __LINE__);
        }
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RCcdHostedDN
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
