<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcdAdvertisingService StructType
 * @subpackage Structs
 */
class RCcdAdvertisingService extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The hostDnGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $hostDnGroup;
    /**
     * The safSipTrunk
     * Meta information extracted from the WSDL
     * - documentation: Either safSipTrunk, safH323Trunk or both should be configured while adding
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $safSipTrunk;
    /**
     * The safH323Trunk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $safH323Trunk;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcdAdvertisingService
     * @uses RCcdAdvertisingService::setName()
     * @uses RCcdAdvertisingService::setDescription()
     * @uses RCcdAdvertisingService::setIsActivated()
     * @uses RCcdAdvertisingService::setHostDnGroup()
     * @uses RCcdAdvertisingService::setSafSipTrunk()
     * @uses RCcdAdvertisingService::setSafH323Trunk()
     * @uses RCcdAdvertisingService::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isActivated
     * @param \StructType\XFkType $hostDnGroup
     * @param \StructType\XFkType $safSipTrunk
     * @param \StructType\XFkType $safH323Trunk
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isActivated = null, \StructType\XFkType $hostDnGroup = null, \StructType\XFkType $safSipTrunk = null, \StructType\XFkType $safH323Trunk = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setHostDnGroup($hostDnGroup)
            ->setSafSipTrunk($safSipTrunk)
            ->setSafH323Trunk($safH323Trunk)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RCcdAdvertisingService
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RCcdAdvertisingService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\RCcdAdvertisingService
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get hostDnGroup value
     * @return \StructType\XFkType|null
     */
    public function getHostDnGroup()
    {
        return $this->hostDnGroup;
    }
    /**
     * Set hostDnGroup value
     * @param \StructType\XFkType $hostDnGroup
     * @return \StructType\RCcdAdvertisingService
     */
    public function setHostDnGroup(\StructType\XFkType $hostDnGroup = null)
    {
        $this->hostDnGroup = $hostDnGroup;
        return $this;
    }
    /**
     * Get safSipTrunk value
     * @return \StructType\XFkType|null
     */
    public function getSafSipTrunk()
    {
        return $this->safSipTrunk;
    }
    /**
     * Set safSipTrunk value
     * @param \StructType\XFkType $safSipTrunk
     * @return \StructType\RCcdAdvertisingService
     */
    public function setSafSipTrunk(\StructType\XFkType $safSipTrunk = null)
    {
        $this->safSipTrunk = $safSipTrunk;
        return $this;
    }
    /**
     * Get safH323Trunk value
     * @return \StructType\XFkType|null
     */
    public function getSafH323Trunk()
    {
        return $this->safH323Trunk;
    }
    /**
     * Set safH323Trunk value
     * @param \StructType\XFkType $safH323Trunk
     * @return \StructType\RCcdAdvertisingService
     */
    public function setSafH323Trunk(\StructType\XFkType $safH323Trunk = null)
    {
        $this->safH323Trunk = $safH323Trunk;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RCcdAdvertisingService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
