<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAarGroupRelationship StructType
 * @subpackage Structs
 */
class RAarGroupRelationship extends AbstractStructBase
{
    /**
     * The aarGroupFromName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarGroupToName;
    /**
     * The prefixDigit
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigit;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAarGroupRelationship
     * @uses RAarGroupRelationship::setAarGroupFromName()
     * @uses RAarGroupRelationship::setAarGroupToName()
     * @uses RAarGroupRelationship::setPrefixDigit()
     * @uses RAarGroupRelationship::setUuid()
     * @param \StructType\XFkType $aarGroupFromName
     * @param \StructType\XFkType $aarGroupToName
     * @param string $prefixDigit
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $aarGroupFromName = null, \StructType\XFkType $aarGroupToName = null, $prefixDigit = null, $uuid = null)
    {
        $this
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName)
            ->setPrefixDigit($prefixDigit)
            ->setUuid($uuid);
    }
    /**
     * Get aarGroupFromName value
     * @return \StructType\XFkType|null
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param \StructType\XFkType $aarGroupFromName
     * @return \StructType\RAarGroupRelationship
     */
    public function setAarGroupFromName(\StructType\XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return \StructType\XFkType|null
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param \StructType\XFkType $aarGroupToName
     * @return \StructType\RAarGroupRelationship
     */
    public function setAarGroupToName(\StructType\XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return \StructType\RAarGroupRelationship
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigit, true), gettype($prefixDigit)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($prefixDigit) && mb_strlen($prefixDigit) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RAarGroupRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
