<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ports StructType
 * @subpackage Structs
 */
class Ports extends AbstractStructBase
{
    /**
     * The port
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XAnalogPort[]
     */
    public $port;
    /**
     * The ethernetPhonePort
     * Meta information extracted from the WSDL
     * - default: 2000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ethernetPhonePort;
    /**
     * The mgcpPorts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MgcpPorts
     */
    public $mgcpPorts;
    /**
     * The sipPorts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SipPorts
     */
    public $sipPorts;
    /**
     * Constructor method for ports
     * @uses Ports::setPort()
     * @uses Ports::setEthernetPhonePort()
     * @uses Ports::setMgcpPorts()
     * @uses Ports::setSipPorts()
     * @param \StructType\XAnalogPort[] $port
     * @param string $ethernetPhonePort
     * @param \StructType\MgcpPorts $mgcpPorts
     * @param \StructType\SipPorts $sipPorts
     */
    public function __construct(array $port = array(), $ethernetPhonePort = '2000', \StructType\MgcpPorts $mgcpPorts = null, \StructType\SipPorts $sipPorts = null)
    {
        $this
            ->setPort($port)
            ->setEthernetPhonePort($ethernetPhonePort)
            ->setMgcpPorts($mgcpPorts)
            ->setSipPorts($sipPorts);
    }
    /**
     * Get port value
     * @return \StructType\XAnalogPort[]
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * This method is responsible for validating the values passed to the setPort method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPort method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePortForArrayConstraintsFromSetPort(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $portsPortItem) {
            // validation for constraint: itemType
            if (!$portsPortItem instanceof \StructType\XAnalogPort) {
                $invalidValues[] = is_object($portsPortItem) ? get_class($portsPortItem) : sprintf('%s(%s)', gettype($portsPortItem), var_export($portsPortItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The port property can only contain items of type \StructType\XAnalogPort, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set port value
     * @throws \InvalidArgumentException
     * @param \StructType\XAnalogPort[] $port
     * @return \StructType\Ports
     */
    public function setPort(array $port = array())
    {
        // validation for constraint: array
        if ('' !== ($portArrayErrorMessage = self::validatePortForArrayConstraintsFromSetPort($port))) {
            throw new \InvalidArgumentException($portArrayErrorMessage, __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Add item to port value
     * @throws \InvalidArgumentException
     * @param \StructType\XAnalogPort $item
     * @return \StructType\Ports
     */
    public function addToPort(\StructType\XAnalogPort $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XAnalogPort) {
            throw new \InvalidArgumentException(sprintf('The port property can only contain items of type \StructType\XAnalogPort, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->port[] = $item;
        return $this;
    }
    /**
     * Get ethernetPhonePort value
     * @return string|null
     */
    public function getEthernetPhonePort()
    {
        return $this->ethernetPhonePort;
    }
    /**
     * Set ethernetPhonePort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ethernetPhonePort
     * @return \StructType\Ports
     */
    public function setEthernetPhonePort($ethernetPhonePort = '2000')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ethernetPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($ethernetPhonePort) ? implode(', ', $ethernetPhonePort) : var_export($ethernetPhonePort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ethernetPhonePort = $ethernetPhonePort;
        return $this;
    }
    /**
     * Get mgcpPorts value
     * @return \StructType\MgcpPorts|null
     */
    public function getMgcpPorts()
    {
        return $this->mgcpPorts;
    }
    /**
     * Set mgcpPorts value
     * @param \StructType\MgcpPorts $mgcpPorts
     * @return \StructType\Ports
     */
    public function setMgcpPorts(\StructType\MgcpPorts $mgcpPorts = null)
    {
        $this->mgcpPorts = $mgcpPorts;
        return $this;
    }
    /**
     * Get sipPorts value
     * @return \StructType\SipPorts|null
     */
    public function getSipPorts()
    {
        return $this->sipPorts;
    }
    /**
     * Set sipPorts value
     * @param \StructType\SipPorts $sipPorts
     * @return \StructType\Ports
     */
    public function setSipPorts(\StructType\SipPorts $sipPorts = null)
    {
        $this->sipPorts = $sipPorts;
        return $this;
    }
}
