<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickupDnAndPartition StructType
 * @subpackage Structs
 */
class PickupDnAndPartition extends AbstractStructBase
{
    /**
     * The dnPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dnPattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * Constructor method for pickupDnAndPartition
     * @uses PickupDnAndPartition::setDnPattern()
     * @uses PickupDnAndPartition::setRoutePartitionName()
     * @param string $dnPattern
     * @param \StructType\XFkType $routePartitionName
     */
    public function __construct($dnPattern = null, \StructType\XFkType $routePartitionName = null)
    {
        $this
            ->setDnPattern($dnPattern)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get dnPattern value
     * @return string
     */
    public function getDnPattern()
    {
        return $this->dnPattern;
    }
    /**
     * Set dnPattern value
     * @param string $dnPattern
     * @return \StructType\PickupDnAndPartition
     */
    public function setDnPattern($dnPattern = null)
    {
        // validation for constraint: string
        if (!is_null($dnPattern) && !is_string($dnPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnPattern, true), gettype($dnPattern)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($dnPattern) && mb_strlen($dnPattern) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($dnPattern)), __LINE__);
        }
        $this->dnPattern = $dnPattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\PickupDnAndPartition
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
}
