<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for passwordCredentials StructType
 * Meta information extracted from the WSDL
 * - documentation: Not Applicable for Add. Credential configuration for password | Not Applicable for Add. Credential configuration for password.
 * @subpackage Structs
 */
class PasswordCredentials extends AbstractStructBase
{
    /**
     * The pwdCredPolicyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $pwdCredPolicyName;
    /**
     * The pwdCredUserCantChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredUserCantChange;
    /**
     * The pwdCredUserMustChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredUserMustChange;
    /**
     * The pwdCredDoesNotExpire
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredDoesNotExpire;
    /**
     * The pwdCredTimeChanged
     * Meta information extracted from the WSDL
     * - documentation: Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pwdCredTimeChanged;
    /**
     * The pwdCredTimeAdminLockout
     * Meta information extracted from the WSDL
     * - documentation: Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pwdCredTimeAdminLockout;
    /**
     * The pwdCredLockedByAdministrator
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdCredLockedByAdministrator;
    /**
     * Constructor method for passwordCredentials
     * @uses PasswordCredentials::setPwdCredPolicyName()
     * @uses PasswordCredentials::setPwdCredUserCantChange()
     * @uses PasswordCredentials::setPwdCredUserMustChange()
     * @uses PasswordCredentials::setPwdCredDoesNotExpire()
     * @uses PasswordCredentials::setPwdCredTimeChanged()
     * @uses PasswordCredentials::setPwdCredTimeAdminLockout()
     * @uses PasswordCredentials::setPwdCredLockedByAdministrator()
     * @param \StructType\XFkType $pwdCredPolicyName
     * @param string $pwdCredUserCantChange
     * @param string $pwdCredUserMustChange
     * @param string $pwdCredDoesNotExpire
     * @param string $pwdCredTimeChanged
     * @param string $pwdCredTimeAdminLockout
     * @param string $pwdCredLockedByAdministrator
     */
    public function __construct(\StructType\XFkType $pwdCredPolicyName = null, $pwdCredUserCantChange = null, $pwdCredUserMustChange = null, $pwdCredDoesNotExpire = null, $pwdCredTimeChanged = null, $pwdCredTimeAdminLockout = null, $pwdCredLockedByAdministrator = null)
    {
        $this
            ->setPwdCredPolicyName($pwdCredPolicyName)
            ->setPwdCredUserCantChange($pwdCredUserCantChange)
            ->setPwdCredUserMustChange($pwdCredUserMustChange)
            ->setPwdCredDoesNotExpire($pwdCredDoesNotExpire)
            ->setPwdCredTimeChanged($pwdCredTimeChanged)
            ->setPwdCredTimeAdminLockout($pwdCredTimeAdminLockout)
            ->setPwdCredLockedByAdministrator($pwdCredLockedByAdministrator);
    }
    /**
     * Get pwdCredPolicyName value
     * @return \StructType\XFkType|null
     */
    public function getPwdCredPolicyName()
    {
        return $this->pwdCredPolicyName;
    }
    /**
     * Set pwdCredPolicyName value
     * @param \StructType\XFkType $pwdCredPolicyName
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredPolicyName(\StructType\XFkType $pwdCredPolicyName = null)
    {
        $this->pwdCredPolicyName = $pwdCredPolicyName;
        return $this;
    }
    /**
     * Get pwdCredUserCantChange value
     * @return string|null
     */
    public function getPwdCredUserCantChange()
    {
        return $this->pwdCredUserCantChange;
    }
    /**
     * Set pwdCredUserCantChange value
     * @param string $pwdCredUserCantChange
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredUserCantChange($pwdCredUserCantChange = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredUserCantChange) && !is_string($pwdCredUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdCredUserCantChange, true), gettype($pwdCredUserCantChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pwdCredUserCantChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pwdCredUserCantChange, true)), __LINE__);
        }
        $this->pwdCredUserCantChange = $pwdCredUserCantChange;
        return $this;
    }
    /**
     * Get pwdCredUserMustChange value
     * @return string|null
     */
    public function getPwdCredUserMustChange()
    {
        return $this->pwdCredUserMustChange;
    }
    /**
     * Set pwdCredUserMustChange value
     * @param string $pwdCredUserMustChange
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredUserMustChange($pwdCredUserMustChange = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredUserMustChange) && !is_string($pwdCredUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdCredUserMustChange, true), gettype($pwdCredUserMustChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pwdCredUserMustChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pwdCredUserMustChange, true)), __LINE__);
        }
        $this->pwdCredUserMustChange = $pwdCredUserMustChange;
        return $this;
    }
    /**
     * Get pwdCredDoesNotExpire value
     * @return string|null
     */
    public function getPwdCredDoesNotExpire()
    {
        return $this->pwdCredDoesNotExpire;
    }
    /**
     * Set pwdCredDoesNotExpire value
     * @param string $pwdCredDoesNotExpire
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredDoesNotExpire($pwdCredDoesNotExpire = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredDoesNotExpire) && !is_string($pwdCredDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdCredDoesNotExpire, true), gettype($pwdCredDoesNotExpire)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pwdCredDoesNotExpire) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pwdCredDoesNotExpire, true)), __LINE__);
        }
        $this->pwdCredDoesNotExpire = $pwdCredDoesNotExpire;
        return $this;
    }
    /**
     * Get pwdCredTimeChanged value
     * @return string|null
     */
    public function getPwdCredTimeChanged()
    {
        return $this->pwdCredTimeChanged;
    }
    /**
     * Set pwdCredTimeChanged value
     * @param string $pwdCredTimeChanged
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredTimeChanged($pwdCredTimeChanged = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredTimeChanged) && !is_string($pwdCredTimeChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdCredTimeChanged, true), gettype($pwdCredTimeChanged)), __LINE__);
        }
        $this->pwdCredTimeChanged = $pwdCredTimeChanged;
        return $this;
    }
    /**
     * Get pwdCredTimeAdminLockout value
     * @return string|null
     */
    public function getPwdCredTimeAdminLockout()
    {
        return $this->pwdCredTimeAdminLockout;
    }
    /**
     * Set pwdCredTimeAdminLockout value
     * @param string $pwdCredTimeAdminLockout
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredTimeAdminLockout($pwdCredTimeAdminLockout = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredTimeAdminLockout) && !is_string($pwdCredTimeAdminLockout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdCredTimeAdminLockout, true), gettype($pwdCredTimeAdminLockout)), __LINE__);
        }
        $this->pwdCredTimeAdminLockout = $pwdCredTimeAdminLockout;
        return $this;
    }
    /**
     * Get pwdCredLockedByAdministrator value
     * @return string|null
     */
    public function getPwdCredLockedByAdministrator()
    {
        return $this->pwdCredLockedByAdministrator;
    }
    /**
     * Set pwdCredLockedByAdministrator value
     * @param string $pwdCredLockedByAdministrator
     * @return \StructType\PasswordCredentials
     */
    public function setPwdCredLockedByAdministrator($pwdCredLockedByAdministrator = null)
    {
        // validation for constraint: string
        if (!is_null($pwdCredLockedByAdministrator) && !is_string($pwdCredLockedByAdministrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdCredLockedByAdministrator, true), gettype($pwdCredLockedByAdministrator)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pwdCredLockedByAdministrator) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdCredLockedByAdministrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pwdCredLockedByAdministrator, true)), __LINE__);
        }
        $this->pwdCredLockedByAdministrator = $pwdCredLockedByAdministrator;
        return $this;
    }
}
