<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXPhoneLine StructType
 * @subpackage Structs
 */
class OXPhoneLine extends AbstractStructBase
{
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXDirn
     */
    public $dirn;
    /**
     * The ringSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta information extracted from the WSDL
     * - documentation: Consecutive Rings Setting. Replaces the consective ring setting on IPPhone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $ringSettingActivePickupAlert;
    /**
     * The mwlPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $mwlPolicy;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $audibleMwi;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $partitionUsage;
    /**
     * The recordingMediaSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $recordingMediaSource;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXPhoneLine
     * @uses OXPhoneLine::setDirn()
     * @uses OXPhoneLine::setRingSetting()
     * @uses OXPhoneLine::setConsecutiveRingSetting()
     * @uses OXPhoneLine::setRingSettingIdlePickupAlert()
     * @uses OXPhoneLine::setRingSettingActivePickupAlert()
     * @uses OXPhoneLine::setMwlPolicy()
     * @uses OXPhoneLine::setRecordingProfileName()
     * @uses OXPhoneLine::setMonitoringCssName()
     * @uses OXPhoneLine::setRecordingFlag()
     * @uses OXPhoneLine::setAudibleMwi()
     * @uses OXPhoneLine::setPartitionUsage()
     * @uses OXPhoneLine::setRecordingMediaSource()
     * @uses OXPhoneLine::setCtiid()
     * @uses OXPhoneLine::setUuid()
     * @param \StructType\OXDirn $dirn
     * @param \StructType\OXFkType $ringSetting
     * @param \StructType\OXFkType $consecutiveRingSetting
     * @param \StructType\OXFkType $ringSettingIdlePickupAlert
     * @param \StructType\OXFkType $ringSettingActivePickupAlert
     * @param \StructType\OXFkType $mwlPolicy
     * @param \StructType\OXFkType $recordingProfileName
     * @param \StructType\OXFkType $monitoringCssName
     * @param \StructType\OXFkType $recordingFlag
     * @param \StructType\OXFkType $audibleMwi
     * @param \StructType\OXFkType $partitionUsage
     * @param \StructType\OXFkType $recordingMediaSource
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\StructType\OXDirn $dirn = null, \StructType\OXFkType $ringSetting = null, \StructType\OXFkType $consecutiveRingSetting = null, \StructType\OXFkType $ringSettingIdlePickupAlert = null, \StructType\OXFkType $ringSettingActivePickupAlert = null, \StructType\OXFkType $mwlPolicy = null, \StructType\OXFkType $recordingProfileName = null, \StructType\OXFkType $monitoringCssName = null, \StructType\OXFkType $recordingFlag = null, \StructType\OXFkType $audibleMwi = null, \StructType\OXFkType $partitionUsage = null, \StructType\OXFkType $recordingMediaSource = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setMwlPolicy($mwlPolicy)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setPartitionUsage($partitionUsage)
            ->setRecordingMediaSource($recordingMediaSource)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return \StructType\OXDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \StructType\OXDirn $dirn
     * @return \StructType\OXPhoneLine
     */
    public function setDirn(\StructType\OXDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return \StructType\OXFkType|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @param \StructType\OXFkType $ringSetting
     * @return \StructType\OXPhoneLine
     */
    public function setRingSetting(\StructType\OXFkType $ringSetting = null)
    {
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * @return \StructType\OXFkType|null
     */
    public function getConsecutiveRingSetting()
    {
        return $this->consecutiveRingSetting;
    }
    /**
     * Set consecutiveRingSetting value
     * @param \StructType\OXFkType $consecutiveRingSetting
     * @return \StructType\OXPhoneLine
     */
    public function setConsecutiveRingSetting(\StructType\OXFkType $consecutiveRingSetting = null)
    {
        $this->consecutiveRingSetting = $consecutiveRingSetting;
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * @return \StructType\OXFkType|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return $this->ringSettingIdlePickupAlert;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * @param \StructType\OXFkType $ringSettingIdlePickupAlert
     * @return \StructType\OXPhoneLine
     */
    public function setRingSettingIdlePickupAlert(\StructType\OXFkType $ringSettingIdlePickupAlert = null)
    {
        $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * @return \StructType\OXFkType|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return $this->ringSettingActivePickupAlert;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * @param \StructType\OXFkType $ringSettingActivePickupAlert
     * @return \StructType\OXPhoneLine
     */
    public function setRingSettingActivePickupAlert(\StructType\OXFkType $ringSettingActivePickupAlert = null)
    {
        $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return \StructType\OXFkType|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @param \StructType\OXFkType $mwlPolicy
     * @return \StructType\OXPhoneLine
     */
    public function setMwlPolicy(\StructType\OXFkType $mwlPolicy = null)
    {
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return \StructType\OXFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param \StructType\OXFkType $recordingProfileName
     * @return \StructType\OXPhoneLine
     */
    public function setRecordingProfileName(\StructType\OXFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return \StructType\OXFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param \StructType\OXFkType $monitoringCssName
     * @return \StructType\OXPhoneLine
     */
    public function setMonitoringCssName(\StructType\OXFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return \StructType\OXFkType|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @param \StructType\OXFkType $recordingFlag
     * @return \StructType\OXPhoneLine
     */
    public function setRecordingFlag(\StructType\OXFkType $recordingFlag = null)
    {
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return \StructType\OXFkType|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @param \StructType\OXFkType $audibleMwi
     * @return \StructType\OXPhoneLine
     */
    public function setAudibleMwi(\StructType\OXFkType $audibleMwi = null)
    {
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return \StructType\OXFkType|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @param \StructType\OXFkType $partitionUsage
     * @return \StructType\OXPhoneLine
     */
    public function setPartitionUsage(\StructType\OXFkType $partitionUsage = null)
    {
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get recordingMediaSource value
     * @return \StructType\OXFkType|null
     */
    public function getRecordingMediaSource()
    {
        return $this->recordingMediaSource;
    }
    /**
     * Set recordingMediaSource value
     * @param \StructType\OXFkType $recordingMediaSource
     * @return \StructType\OXPhoneLine
     */
    public function setRecordingMediaSource(\StructType\OXFkType $recordingMediaSource = null)
    {
        $this->recordingMediaSource = $recordingMediaSource;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\OXPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXPhoneLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
