<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXLine StructType
 * @subpackage Structs
 */
class OXLine extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callForwardAll
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta information extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $releaseClause;
    /**
     * The cfaCssPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The partyEntranceTone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $partyEntranceTone;
    /**
     * The directoryURIs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DirectoryURIs
     */
    public $directoryURIs;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXLine
     * @uses OXLine::setUsage()
     * @uses OXLine::setRoutePartitionName()
     * @uses OXLine::setAarNeighborhoodName()
     * @uses OXLine::setCallForwardAll()
     * @uses OXLine::setCallForwardBusy()
     * @uses OXLine::setCallForwardBusyInt()
     * @uses OXLine::setCallForwardNoAnswer()
     * @uses OXLine::setCallForwardNoAnswerInt()
     * @uses OXLine::setCallForwardNoCoverage()
     * @uses OXLine::setCallForwardNoCoverageInt()
     * @uses OXLine::setCallForwardOnFailure()
     * @uses OXLine::setCallForwardAlternateParty()
     * @uses OXLine::setCallForwardNotRegistered()
     * @uses OXLine::setCallForwardNotRegisteredInt()
     * @uses OXLine::setCallPickupGroupName()
     * @uses OXLine::setAutoAnswer()
     * @uses OXLine::setNetworkHoldMohAudioSourceId()
     * @uses OXLine::setUserHoldMohAudioSourceId()
     * @uses OXLine::setPresenceGroupName()
     * @uses OXLine::setShareLineAppearanceCssName()
     * @uses OXLine::setVoiceMailProfileName()
     * @uses OXLine::setPatternPrecedence()
     * @uses OXLine::setReleaseClause()
     * @uses OXLine::setCfaCssPolicy()
     * @uses OXLine::setDefaultActivatedDeviceName()
     * @uses OXLine::setParkMonForwardNoRetrieveCssName()
     * @uses OXLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses OXLine::setPartyEntranceTone()
     * @uses OXLine::setDirectoryURIs()
     * @uses OXLine::setConfidentialAccess()
     * @uses OXLine::setExternalCallControlProfile()
     * @uses OXLine::setEnterpriseAltNum()
     * @uses OXLine::setE164AltNum()
     * @uses OXLine::setUuid()
     * @param \StructType\OXFkType $usage
     * @param \StructType\OXFkType $routePartitionName
     * @param \StructType\OXFkType $aarNeighborhoodName
     * @param \StructType\OXCallForwardAll $callForwardAll
     * @param \StructType\OXCallForwardBusy $callForwardBusy
     * @param \StructType\OXCallForwardBusyInt $callForwardBusyInt
     * @param \StructType\OXCallForwardNoAnswer $callForwardNoAnswer
     * @param \StructType\OXCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param \StructType\OXCallForwardNoCoverage $callForwardNoCoverage
     * @param \StructType\OXCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param \StructType\OXCallForwardOnFailure $callForwardOnFailure
     * @param \StructType\OXCallForwardAlternateParty $callForwardAlternateParty
     * @param \StructType\OXCallForwardNotRegistered $callForwardNotRegistered
     * @param \StructType\OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param \StructType\OXFkType $callPickupGroupName
     * @param \StructType\OXFkType $autoAnswer
     * @param \StructType\OXFkType $networkHoldMohAudioSourceId
     * @param \StructType\OXFkType $userHoldMohAudioSourceId
     * @param \StructType\OXFkType $presenceGroupName
     * @param \StructType\OXFkType $shareLineAppearanceCssName
     * @param \StructType\OXFkType $voiceMailProfileName
     * @param \StructType\OXFkType $patternPrecedence
     * @param \StructType\OXFkType $releaseClause
     * @param \StructType\OXFkType $cfaCssPolicy
     * @param \StructType\OXFkType $defaultActivatedDeviceName
     * @param \StructType\OXFkType $parkMonForwardNoRetrieveCssName
     * @param \StructType\OXFkType $parkMonForwardNoRetrieveIntCssName
     * @param \StructType\OXFkType $partyEntranceTone
     * @param \StructType\DirectoryURIs $directoryURIs
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\OXFkType $externalCallControlProfile
     * @param \StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \StructType\E164AltNum $e164AltNum
     * @param string $uuid
     */
    public function __construct(\StructType\OXFkType $usage = null, \StructType\OXFkType $routePartitionName = null, \StructType\OXFkType $aarNeighborhoodName = null, \StructType\OXCallForwardAll $callForwardAll = null, \StructType\OXCallForwardBusy $callForwardBusy = null, \StructType\OXCallForwardBusyInt $callForwardBusyInt = null, \StructType\OXCallForwardNoAnswer $callForwardNoAnswer = null, \StructType\OXCallForwardNoAnswerInt $callForwardNoAnswerInt = null, \StructType\OXCallForwardNoCoverage $callForwardNoCoverage = null, \StructType\OXCallForwardNoCoverageInt $callForwardNoCoverageInt = null, \StructType\OXCallForwardOnFailure $callForwardOnFailure = null, \StructType\OXCallForwardAlternateParty $callForwardAlternateParty = null, \StructType\OXCallForwardNotRegistered $callForwardNotRegistered = null, \StructType\OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, \StructType\OXFkType $callPickupGroupName = null, \StructType\OXFkType $autoAnswer = null, \StructType\OXFkType $networkHoldMohAudioSourceId = null, \StructType\OXFkType $userHoldMohAudioSourceId = null, \StructType\OXFkType $presenceGroupName = null, \StructType\OXFkType $shareLineAppearanceCssName = null, \StructType\OXFkType $voiceMailProfileName = null, \StructType\OXFkType $patternPrecedence = null, \StructType\OXFkType $releaseClause = null, \StructType\OXFkType $cfaCssPolicy = null, \StructType\OXFkType $defaultActivatedDeviceName = null, \StructType\OXFkType $parkMonForwardNoRetrieveCssName = null, \StructType\OXFkType $parkMonForwardNoRetrieveIntCssName = null, \StructType\OXFkType $partyEntranceTone = null, \StructType\DirectoryURIs $directoryURIs = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\OXFkType $externalCallControlProfile = null, \StructType\EnterpriseAltNum $enterpriseAltNum = null, \StructType\E164AltNum $e164AltNum = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setDirectoryURIs($directoryURIs)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return \StructType\OXFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param \StructType\OXFkType $usage
     * @return \StructType\OXLine
     */
    public function setUsage(\StructType\OXFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\OXFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\OXFkType $routePartitionName
     * @return \StructType\OXLine
     */
    public function setRoutePartitionName(\StructType\OXFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\OXFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\OXFkType $aarNeighborhoodName
     * @return \StructType\OXLine
     */
    public function setAarNeighborhoodName(\StructType\OXFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return \StructType\OXCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param \StructType\OXCallForwardAll $callForwardAll
     * @return \StructType\OXLine
     */
    public function setCallForwardAll(\StructType\OXCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return \StructType\OXCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param \StructType\OXCallForwardBusy $callForwardBusy
     * @return \StructType\OXLine
     */
    public function setCallForwardBusy(\StructType\OXCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return \StructType\OXCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param \StructType\OXCallForwardBusyInt $callForwardBusyInt
     * @return \StructType\OXLine
     */
    public function setCallForwardBusyInt(\StructType\OXCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return \StructType\OXCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param \StructType\OXCallForwardNoAnswer $callForwardNoAnswer
     * @return \StructType\OXLine
     */
    public function setCallForwardNoAnswer(\StructType\OXCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return \StructType\OXCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param \StructType\OXCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return \StructType\OXLine
     */
    public function setCallForwardNoAnswerInt(\StructType\OXCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return \StructType\OXCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param \StructType\OXCallForwardNoCoverage $callForwardNoCoverage
     * @return \StructType\OXLine
     */
    public function setCallForwardNoCoverage(\StructType\OXCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return \StructType\OXCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param \StructType\OXCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return \StructType\OXLine
     */
    public function setCallForwardNoCoverageInt(\StructType\OXCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return \StructType\OXCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param \StructType\OXCallForwardOnFailure $callForwardOnFailure
     * @return \StructType\OXLine
     */
    public function setCallForwardOnFailure(\StructType\OXCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return \StructType\OXCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param \StructType\OXCallForwardAlternateParty $callForwardAlternateParty
     * @return \StructType\OXLine
     */
    public function setCallForwardAlternateParty(\StructType\OXCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return \StructType\OXCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param \StructType\OXCallForwardNotRegistered $callForwardNotRegistered
     * @return \StructType\OXLine
     */
    public function setCallForwardNotRegistered(\StructType\OXCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return \StructType\OXCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param \StructType\OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return \StructType\OXLine
     */
    public function setCallForwardNotRegisteredInt(\StructType\OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \StructType\OXFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \StructType\OXFkType $callPickupGroupName
     * @return \StructType\OXLine
     */
    public function setCallPickupGroupName(\StructType\OXFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return \StructType\OXFkType|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @param \StructType\OXFkType $autoAnswer
     * @return \StructType\OXLine
     */
    public function setAutoAnswer(\StructType\OXFkType $autoAnswer = null)
    {
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return \StructType\OXFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param \StructType\OXFkType $networkHoldMohAudioSourceId
     * @return \StructType\OXLine
     */
    public function setNetworkHoldMohAudioSourceId(\StructType\OXFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \StructType\OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \StructType\OXFkType $userHoldMohAudioSourceId
     * @return \StructType\OXLine
     */
    public function setUserHoldMohAudioSourceId(\StructType\OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\OXFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\OXFkType $presenceGroupName
     * @return \StructType\OXLine
     */
    public function setPresenceGroupName(\StructType\OXFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return \StructType\OXFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param \StructType\OXFkType $shareLineAppearanceCssName
     * @return \StructType\OXLine
     */
    public function setShareLineAppearanceCssName(\StructType\OXFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \StructType\OXFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \StructType\OXFkType $voiceMailProfileName
     * @return \StructType\OXLine
     */
    public function setVoiceMailProfileName(\StructType\OXFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return \StructType\OXFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param \StructType\OXFkType $patternPrecedence
     * @return \StructType\OXLine
     */
    public function setPatternPrecedence(\StructType\OXFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return \StructType\OXFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param \StructType\OXFkType $releaseClause
     * @return \StructType\OXLine
     */
    public function setReleaseClause(\StructType\OXFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return \StructType\OXFkType|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @param \StructType\OXFkType $cfaCssPolicy
     * @return \StructType\OXLine
     */
    public function setCfaCssPolicy(\StructType\OXFkType $cfaCssPolicy = null)
    {
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return \StructType\OXFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param \StructType\OXFkType $defaultActivatedDeviceName
     * @return \StructType\OXLine
     */
    public function setDefaultActivatedDeviceName(\StructType\OXFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return \StructType\OXFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param \StructType\OXFkType $parkMonForwardNoRetrieveCssName
     * @return \StructType\OXLine
     */
    public function setParkMonForwardNoRetrieveCssName(\StructType\OXFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return \StructType\OXFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param \StructType\OXFkType $parkMonForwardNoRetrieveIntCssName
     * @return \StructType\OXLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(\StructType\OXFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return \StructType\OXFkType|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @param \StructType\OXFkType $partyEntranceTone
     * @return \StructType\OXLine
     */
    public function setPartyEntranceTone(\StructType\OXFkType $partyEntranceTone = null)
    {
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get directoryURIs value
     * @return \StructType\DirectoryURIs|null
     */
    public function getDirectoryURIs()
    {
        return $this->directoryURIs;
    }
    /**
     * Set directoryURIs value
     * @param \StructType\DirectoryURIs $directoryURIs
     * @return \StructType\OXLine
     */
    public function setDirectoryURIs(\StructType\DirectoryURIs $directoryURIs = null)
    {
        $this->directoryURIs = $directoryURIs;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\OXLine
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * @return \StructType\OXFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return $this->externalCallControlProfile;
    }
    /**
     * Set externalCallControlProfile value
     * @param \StructType\OXFkType $externalCallControlProfile
     * @return \StructType\OXLine
     */
    public function setExternalCallControlProfile(\StructType\OXFkType $externalCallControlProfile = null)
    {
        $this->externalCallControlProfile = $externalCallControlProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \StructType\OXLine
     */
    public function setEnterpriseAltNum(\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \StructType\E164AltNum $e164AltNum
     * @return \StructType\OXLine
     */
    public function setE164AltNum(\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
