<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXFkTypeProduct_Protocol StructType
 * @subpackage Structs
 */
class OXFkTypeProduct_Protocol extends OXFkType
{
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * The protocol
     * @var string
     */
    public $protocol;
    /**
     * Constructor method for OXFkTypeProduct_Protocol
     * @uses OXFkTypeProduct_Protocol::setProduct()
     * @uses OXFkTypeProduct_Protocol::setProtocol()
     * @param string $product
     * @param string $protocol
     */
    public function __construct($product = null, $protocol = null)
    {
        $this
            ->setProduct($product)
            ->setProtocol($protocol);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\OXFkTypeProduct_Protocol
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \StructType\OXFkTypeProduct_Protocol
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocol, true), gettype($protocol)), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
}
