<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXDirectoryUri StructType
 * @subpackage Structs
 */
class OXDirectoryUri extends AbstractStructBase
{
    /**
     * The partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXDirectoryUri
     * @uses OXDirectoryUri::setPartition()
     * @uses OXDirectoryUri::setUuid()
     * @param \StructType\OXFkType $partition
     * @param string $uuid
     */
    public function __construct(\StructType\OXFkType $partition = null, $uuid = null)
    {
        $this
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get partition value
     * @return \StructType\OXFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param \StructType\OXFkType $partition
     * @return \StructType\OXDirectoryUri
     */
    public function setPartition(\StructType\OXFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXDirectoryUri
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
