<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORTransPattern StructType
 * @subpackage Structs
 */
class ORTransPattern extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $routePartitionName;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $patternPrecedence;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $releaseClause;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORTransPattern
     * @uses ORTransPattern::setUsage()
     * @uses ORTransPattern::setRoutePartitionName()
     * @uses ORTransPattern::setUseCallingPartyPhoneMask()
     * @uses ORTransPattern::setDialPlanName()
     * @uses ORTransPattern::setDigitDiscardInstructionName()
     * @uses ORTransPattern::setRouteFilterName()
     * @uses ORTransPattern::setCallingLinePresentationBit()
     * @uses ORTransPattern::setCallingNamePresentationBit()
     * @uses ORTransPattern::setConnectedLinePresentationBit()
     * @uses ORTransPattern::setConnectedNamePresentationBit()
     * @uses ORTransPattern::setPatternPrecedence()
     * @uses ORTransPattern::setCallingPartyNumberingPlan()
     * @uses ORTransPattern::setCallingPartyNumberType()
     * @uses ORTransPattern::setCalledPartyNumberingPlan()
     * @uses ORTransPattern::setCalledPartyNumberType()
     * @uses ORTransPattern::setCallingSearchSpaceName()
     * @uses ORTransPattern::setResourcePriorityNamespaceName()
     * @uses ORTransPattern::setRouteClass()
     * @uses ORTransPattern::setCallInterceptProfileName()
     * @uses ORTransPattern::setReleaseClause()
     * @uses ORTransPattern::setUuid()
     * @param \StructType\ORFkType $usage
     * @param \StructType\ORFkType $routePartitionName
     * @param \StructType\ORFkType $useCallingPartyPhoneMask
     * @param \StructType\ORFkType $dialPlanName
     * @param \StructType\ORFkType $digitDiscardInstructionName
     * @param \StructType\ORFkType $routeFilterName
     * @param \StructType\ORFkType $callingLinePresentationBit
     * @param \StructType\ORFkType $callingNamePresentationBit
     * @param \StructType\ORFkType $connectedLinePresentationBit
     * @param \StructType\ORFkType $connectedNamePresentationBit
     * @param \StructType\ORFkType $patternPrecedence
     * @param \StructType\ORFkType $callingPartyNumberingPlan
     * @param \StructType\ORFkType $callingPartyNumberType
     * @param \StructType\ORFkType $calledPartyNumberingPlan
     * @param \StructType\ORFkType $calledPartyNumberType
     * @param \StructType\ORFkType $callingSearchSpaceName
     * @param \StructType\ORFkType $resourcePriorityNamespaceName
     * @param \StructType\ORFkType $routeClass
     * @param \StructType\ORFkType $callInterceptProfileName
     * @param \StructType\ORFkType $releaseClause
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $usage = null, \StructType\ORFkType $routePartitionName = null, \StructType\ORFkType $useCallingPartyPhoneMask = null, \StructType\ORFkType $dialPlanName = null, \StructType\ORFkType $digitDiscardInstructionName = null, \StructType\ORFkType $routeFilterName = null, \StructType\ORFkType $callingLinePresentationBit = null, \StructType\ORFkType $callingNamePresentationBit = null, \StructType\ORFkType $connectedLinePresentationBit = null, \StructType\ORFkType $connectedNamePresentationBit = null, \StructType\ORFkType $patternPrecedence = null, \StructType\ORFkType $callingPartyNumberingPlan = null, \StructType\ORFkType $callingPartyNumberType = null, \StructType\ORFkType $calledPartyNumberingPlan = null, \StructType\ORFkType $calledPartyNumberType = null, \StructType\ORFkType $callingSearchSpaceName = null, \StructType\ORFkType $resourcePriorityNamespaceName = null, \StructType\ORFkType $routeClass = null, \StructType\ORFkType $callInterceptProfileName = null, \StructType\ORFkType $releaseClause = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return \StructType\ORFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param \StructType\ORFkType $usage
     * @return \StructType\ORTransPattern
     */
    public function setUsage(\StructType\ORFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\ORFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\ORFkType $routePartitionName
     * @return \StructType\ORTransPattern
     */
    public function setRoutePartitionName(\StructType\ORFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return \StructType\ORFkType|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param \StructType\ORFkType $useCallingPartyPhoneMask
     * @return \StructType\ORTransPattern
     */
    public function setUseCallingPartyPhoneMask(\StructType\ORFkType $useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \StructType\ORFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \StructType\ORFkType $dialPlanName
     * @return \StructType\ORTransPattern
     */
    public function setDialPlanName(\StructType\ORFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \StructType\ORFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \StructType\ORFkType $digitDiscardInstructionName
     * @return \StructType\ORTransPattern
     */
    public function setDigitDiscardInstructionName(\StructType\ORFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \StructType\ORFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \StructType\ORFkType $routeFilterName
     * @return \StructType\ORTransPattern
     */
    public function setRouteFilterName(\StructType\ORFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return \StructType\ORFkType|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param \StructType\ORFkType $callingLinePresentationBit
     * @return \StructType\ORTransPattern
     */
    public function setCallingLinePresentationBit(\StructType\ORFkType $callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return \StructType\ORFkType|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param \StructType\ORFkType $callingNamePresentationBit
     * @return \StructType\ORTransPattern
     */
    public function setCallingNamePresentationBit(\StructType\ORFkType $callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return \StructType\ORFkType|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param \StructType\ORFkType $connectedLinePresentationBit
     * @return \StructType\ORTransPattern
     */
    public function setConnectedLinePresentationBit(\StructType\ORFkType $connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return \StructType\ORFkType|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param \StructType\ORFkType $connectedNamePresentationBit
     * @return \StructType\ORTransPattern
     */
    public function setConnectedNamePresentationBit(\StructType\ORFkType $connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return \StructType\ORFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param \StructType\ORFkType $patternPrecedence
     * @return \StructType\ORTransPattern
     */
    public function setPatternPrecedence(\StructType\ORFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return \StructType\ORFkType|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param \StructType\ORFkType $callingPartyNumberingPlan
     * @return \StructType\ORTransPattern
     */
    public function setCallingPartyNumberingPlan(\StructType\ORFkType $callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return \StructType\ORFkType|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param \StructType\ORFkType $callingPartyNumberType
     * @return \StructType\ORTransPattern
     */
    public function setCallingPartyNumberType(\StructType\ORFkType $callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return \StructType\ORFkType|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param \StructType\ORFkType $calledPartyNumberingPlan
     * @return \StructType\ORTransPattern
     */
    public function setCalledPartyNumberingPlan(\StructType\ORFkType $calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return \StructType\ORFkType|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param \StructType\ORFkType $calledPartyNumberType
     * @return \StructType\ORTransPattern
     */
    public function setCalledPartyNumberType(\StructType\ORFkType $calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\ORFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\ORFkType $callingSearchSpaceName
     * @return \StructType\ORTransPattern
     */
    public function setCallingSearchSpaceName(\StructType\ORFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return \StructType\ORFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param \StructType\ORFkType $resourcePriorityNamespaceName
     * @return \StructType\ORTransPattern
     */
    public function setResourcePriorityNamespaceName(\StructType\ORFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return \StructType\ORFkType|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param \StructType\ORFkType $routeClass
     * @return \StructType\ORTransPattern
     */
    public function setRouteClass(\StructType\ORFkType $routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return \StructType\ORFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param \StructType\ORFkType $callInterceptProfileName
     * @return \StructType\ORTransPattern
     */
    public function setCallInterceptProfileName(\StructType\ORFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return \StructType\ORFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param \StructType\ORFkType $releaseClause
     * @return \StructType\ORTransPattern
     */
    public function setReleaseClause(\StructType\ORFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORTransPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
