<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORPhone StructType
 * @subpackage Structs
 */
class ORPhone extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $aarNeighborhoodName;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta information extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $geoLocationFilterName;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $networkLocale;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $softkeyTemplateName;
    /**
     * The defaultProfileName
     * Meta information extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $defaultProfileName;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The ownerUserName
     * Meta information extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $ownerUserName;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $packetCaptureMode;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $presenceGroupName;
    /**
     * The certificateOperation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $keySize;
    /**
     * The deviceMobilityMode
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $deviceMobilityMode;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dndRingSetting;
    /**
     * The mobilityUserIdName
     * Meta information extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta information extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $phoneServiceDisplay;
    /**
     * The mtpPreferedCodec
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dialRulesName;
    /**
     * The outboundCallRollover
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $outboundCallRollover;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $deviceTrustMode;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The cgpnIngressDN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $cgpnIngressDN;
    /**
     * The wifiHotspotProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORPhone
     * @uses ORPhone::setProduct()
     * @uses ORPhone::setClass()
     * @uses ORPhone::setProtocol()
     * @uses ORPhone::setProtocolSide()
     * @uses ORPhone::setCallingSearchSpaceName()
     * @uses ORPhone::setDevicePoolName()
     * @uses ORPhone::setCommonDeviceConfigName()
     * @uses ORPhone::setCommonPhoneConfigName()
     * @uses ORPhone::setNetworkLocation()
     * @uses ORPhone::setLocationName()
     * @uses ORPhone::setMediaResourceListName()
     * @uses ORPhone::setNetworkHoldMohAudioSourceId()
     * @uses ORPhone::setUserHoldMohAudioSourceId()
     * @uses ORPhone::setAutomatedAlternateRoutingCssName()
     * @uses ORPhone::setAarNeighborhoodName()
     * @uses ORPhone::setMlppIndicationStatus()
     * @uses ORPhone::setPreemption()
     * @uses ORPhone::setUseTrustedRelayPoint()
     * @uses ORPhone::setSecurityProfileName()
     * @uses ORPhone::setSipProfileName()
     * @uses ORPhone::setCgpnTransformationCssName()
     * @uses ORPhone::setGeoLocationName()
     * @uses ORPhone::setGeoLocationFilterName()
     * @uses ORPhone::setLines()
     * @uses ORPhone::setPhoneTemplateName()
     * @uses ORPhone::setPrimaryPhoneName()
     * @uses ORPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses ORPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses ORPhone::setBlfDirectedCallParks()
     * @uses ORPhone::setAddOnModules()
     * @uses ORPhone::setUserLocale()
     * @uses ORPhone::setNetworkLocale()
     * @uses ORPhone::setServices()
     * @uses ORPhone::setSoftkeyTemplateName()
     * @uses ORPhone::setDefaultProfileName()
     * @uses ORPhone::setSingleButtonBarge()
     * @uses ORPhone::setJoinAcrossLines()
     * @uses ORPhone::setBuiltInBridgeStatus()
     * @uses ORPhone::setCallInfoPrivacyStatus()
     * @uses ORPhone::setOwnerUserName()
     * @uses ORPhone::setPacketCaptureMode()
     * @uses ORPhone::setSubscribeCallingSearchSpaceName()
     * @uses ORPhone::setRerouteCallingSearchSpaceName()
     * @uses ORPhone::setPresenceGroupName()
     * @uses ORPhone::setCertificateOperation()
     * @uses ORPhone::setAuthenticationMode()
     * @uses ORPhone::setKeySize()
     * @uses ORPhone::setDeviceMobilityMode()
     * @uses ORPhone::setDndOption()
     * @uses ORPhone::setDndRingSetting()
     * @uses ORPhone::setMobilityUserIdName()
     * @uses ORPhone::setPhoneSuite()
     * @uses ORPhone::setPhoneServiceDisplay()
     * @uses ORPhone::setMtpPreferedCodec()
     * @uses ORPhone::setDialRulesName()
     * @uses ORPhone::setOutboundCallRollover()
     * @uses ORPhone::setAlwaysUsePrimeLine()
     * @uses ORPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses ORPhone::setFeatureControlPolicy()
     * @uses ORPhone::setDeviceTrustMode()
     * @uses ORPhone::setConfidentialAccess()
     * @uses ORPhone::setCgpnIngressDN()
     * @uses ORPhone::setWifiHotspotProfile()
     * @uses ORPhone::setWirelessLanProfileGroup()
     * @uses ORPhone::setCtiid()
     * @uses ORPhone::setUuid()
     * @param \StructType\ORFkType $product
     * @param \StructType\ORFkType $class
     * @param \StructType\ORFkType $protocol
     * @param \StructType\ORFkType $protocolSide
     * @param \StructType\ORFkType $callingSearchSpaceName
     * @param \StructType\ORFkType $devicePoolName
     * @param \StructType\ORFkType $commonDeviceConfigName
     * @param \StructType\ORFkType $commonPhoneConfigName
     * @param \StructType\ORFkType $networkLocation
     * @param \StructType\ORFkType $locationName
     * @param \StructType\ORFkType $mediaResourceListName
     * @param \StructType\ORFkType $networkHoldMohAudioSourceId
     * @param \StructType\ORFkType $userHoldMohAudioSourceId
     * @param \StructType\ORFkType $automatedAlternateRoutingCssName
     * @param \StructType\ORFkType $aarNeighborhoodName
     * @param \StructType\ORFkType $mlppIndicationStatus
     * @param \StructType\ORFkType $preemption
     * @param \StructType\ORFkType $useTrustedRelayPoint
     * @param \StructType\ORFkType $securityProfileName
     * @param \StructType\ORFkType $sipProfileName
     * @param \StructType\ORFkType $cgpnTransformationCssName
     * @param \StructType\ORFkType $geoLocationName
     * @param \StructType\ORFkType $geoLocationFilterName
     * @param \StructType\Lines $lines
     * @param \StructType\ORFkType $phoneTemplateName
     * @param \StructType\ORFkType $primaryPhoneName
     * @param \StructType\ORFkType $ringSettingIdleBlfAudibleAlert
     * @param \StructType\ORFkType $ringSettingBusyBlfAudibleAlert
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \StructType\AddOnModules $addOnModules
     * @param \StructType\ORFkType $userLocale
     * @param \StructType\ORFkType $networkLocale
     * @param \StructType\Services $services
     * @param \StructType\ORFkType $softkeyTemplateName
     * @param \StructType\ORFkType $defaultProfileName
     * @param \StructType\ORFkType $singleButtonBarge
     * @param \StructType\ORFkType $joinAcrossLines
     * @param \StructType\ORFkType $builtInBridgeStatus
     * @param \StructType\ORFkType $callInfoPrivacyStatus
     * @param \StructType\ORFkType $ownerUserName
     * @param \StructType\ORFkType $packetCaptureMode
     * @param \StructType\ORFkType $subscribeCallingSearchSpaceName
     * @param \StructType\ORFkType $rerouteCallingSearchSpaceName
     * @param \StructType\ORFkType $presenceGroupName
     * @param \StructType\ORFkType $certificateOperation
     * @param \StructType\ORFkType $authenticationMode
     * @param \StructType\ORFkType $keySize
     * @param \StructType\ORFkType $deviceMobilityMode
     * @param \StructType\ORFkType $dndOption
     * @param \StructType\ORFkType $dndRingSetting
     * @param \StructType\ORFkType $mobilityUserIdName
     * @param \StructType\ORFkType $phoneSuite
     * @param \StructType\ORFkType $phoneServiceDisplay
     * @param \StructType\ORFkType $mtpPreferedCodec
     * @param \StructType\ORFkType $dialRulesName
     * @param \StructType\ORFkType $outboundCallRollover
     * @param \StructType\ORFkType $alwaysUsePrimeLine
     * @param \StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @param \StructType\ORFkType $featureControlPolicy
     * @param \StructType\ORFkType $deviceTrustMode
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\ORFkType $cgpnIngressDN
     * @param \StructType\ORFkType $wifiHotspotProfile
     * @param \StructType\ORFkType $wirelessLanProfileGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $product = null, \StructType\ORFkType $class = null, \StructType\ORFkType $protocol = null, \StructType\ORFkType $protocolSide = null, \StructType\ORFkType $callingSearchSpaceName = null, \StructType\ORFkType $devicePoolName = null, \StructType\ORFkType $commonDeviceConfigName = null, \StructType\ORFkType $commonPhoneConfigName = null, \StructType\ORFkType $networkLocation = null, \StructType\ORFkType $locationName = null, \StructType\ORFkType $mediaResourceListName = null, \StructType\ORFkType $networkHoldMohAudioSourceId = null, \StructType\ORFkType $userHoldMohAudioSourceId = null, \StructType\ORFkType $automatedAlternateRoutingCssName = null, \StructType\ORFkType $aarNeighborhoodName = null, \StructType\ORFkType $mlppIndicationStatus = null, \StructType\ORFkType $preemption = null, \StructType\ORFkType $useTrustedRelayPoint = null, \StructType\ORFkType $securityProfileName = null, \StructType\ORFkType $sipProfileName = null, \StructType\ORFkType $cgpnTransformationCssName = null, \StructType\ORFkType $geoLocationName = null, \StructType\ORFkType $geoLocationFilterName = null, \StructType\Lines $lines = null, \StructType\ORFkType $phoneTemplateName = null, \StructType\ORFkType $primaryPhoneName = null, \StructType\ORFkType $ringSettingIdleBlfAudibleAlert = null, \StructType\ORFkType $ringSettingBusyBlfAudibleAlert = null, \StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \StructType\AddOnModules $addOnModules = null, \StructType\ORFkType $userLocale = null, \StructType\ORFkType $networkLocale = null, \StructType\Services $services = null, \StructType\ORFkType $softkeyTemplateName = null, \StructType\ORFkType $defaultProfileName = null, \StructType\ORFkType $singleButtonBarge = null, \StructType\ORFkType $joinAcrossLines = null, \StructType\ORFkType $builtInBridgeStatus = null, \StructType\ORFkType $callInfoPrivacyStatus = null, \StructType\ORFkType $ownerUserName = null, \StructType\ORFkType $packetCaptureMode = null, \StructType\ORFkType $subscribeCallingSearchSpaceName = null, \StructType\ORFkType $rerouteCallingSearchSpaceName = null, \StructType\ORFkType $presenceGroupName = null, \StructType\ORFkType $certificateOperation = null, \StructType\ORFkType $authenticationMode = null, \StructType\ORFkType $keySize = null, \StructType\ORFkType $deviceMobilityMode = null, \StructType\ORFkType $dndOption = null, \StructType\ORFkType $dndRingSetting = null, \StructType\ORFkType $mobilityUserIdName = null, \StructType\ORFkType $phoneSuite = null, \StructType\ORFkType $phoneServiceDisplay = null, \StructType\ORFkType $mtpPreferedCodec = null, \StructType\ORFkType $dialRulesName = null, \StructType\ORFkType $outboundCallRollover = null, \StructType\ORFkType $alwaysUsePrimeLine = null, \StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage = null, \StructType\ORFkType $featureControlPolicy = null, \StructType\ORFkType $deviceTrustMode = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\ORFkType $cgpnIngressDN = null, \StructType\ORFkType $wifiHotspotProfile = null, \StructType\ORFkType $wirelessLanProfileGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setDefaultProfileName($defaultProfileName)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setOwnerUserName($ownerUserName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setPresenceGroupName($presenceGroupName)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setConfidentialAccess($confidentialAccess)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return \StructType\ORFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ORFkType $product
     * @return \StructType\ORPhone
     */
    public function setProduct(\StructType\ORFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\ORFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\ORFkType $class
     * @return \StructType\ORPhone
     */
    public function setClass(\StructType\ORFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return \StructType\ORFkType|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param \StructType\ORFkType $protocol
     * @return \StructType\ORPhone
     */
    public function setProtocol(\StructType\ORFkType $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return \StructType\ORFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param \StructType\ORFkType $protocolSide
     * @return \StructType\ORPhone
     */
    public function setProtocolSide(\StructType\ORFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\ORFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\ORFkType $callingSearchSpaceName
     * @return \StructType\ORPhone
     */
    public function setCallingSearchSpaceName(\StructType\ORFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\ORFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\ORFkType $devicePoolName
     * @return \StructType\ORPhone
     */
    public function setDevicePoolName(\StructType\ORFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\ORFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\ORFkType $commonDeviceConfigName
     * @return \StructType\ORPhone
     */
    public function setCommonDeviceConfigName(\StructType\ORFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \StructType\ORFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \StructType\ORFkType $commonPhoneConfigName
     * @return \StructType\ORPhone
     */
    public function setCommonPhoneConfigName(\StructType\ORFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return \StructType\ORFkType|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param \StructType\ORFkType $networkLocation
     * @return \StructType\ORPhone
     */
    public function setNetworkLocation(\StructType\ORFkType $networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\ORFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\ORFkType $locationName
     * @return \StructType\ORPhone
     */
    public function setLocationName(\StructType\ORFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \StructType\ORFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \StructType\ORFkType $mediaResourceListName
     * @return \StructType\ORPhone
     */
    public function setMediaResourceListName(\StructType\ORFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return \StructType\ORFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param \StructType\ORFkType $networkHoldMohAudioSourceId
     * @return \StructType\ORPhone
     */
    public function setNetworkHoldMohAudioSourceId(\StructType\ORFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \StructType\ORFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \StructType\ORFkType $userHoldMohAudioSourceId
     * @return \StructType\ORPhone
     */
    public function setUserHoldMohAudioSourceId(\StructType\ORFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\ORFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\ORFkType $automatedAlternateRoutingCssName
     * @return \StructType\ORPhone
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\ORFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\ORFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\ORFkType $aarNeighborhoodName
     * @return \StructType\ORPhone
     */
    public function setAarNeighborhoodName(\StructType\ORFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return \StructType\ORFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param \StructType\ORFkType $mlppIndicationStatus
     * @return \StructType\ORPhone
     */
    public function setMlppIndicationStatus(\StructType\ORFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return \StructType\ORFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param \StructType\ORFkType $preemption
     * @return \StructType\ORPhone
     */
    public function setPreemption(\StructType\ORFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return \StructType\ORFkType|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param \StructType\ORFkType $useTrustedRelayPoint
     * @return \StructType\ORPhone
     */
    public function setUseTrustedRelayPoint(\StructType\ORFkType $useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \StructType\ORFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \StructType\ORFkType $securityProfileName
     * @return \StructType\ORPhone
     */
    public function setSecurityProfileName(\StructType\ORFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \StructType\ORFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \StructType\ORFkType $sipProfileName
     * @return \StructType\ORPhone
     */
    public function setSipProfileName(\StructType\ORFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\ORFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\ORFkType $cgpnTransformationCssName
     * @return \StructType\ORPhone
     */
    public function setCgpnTransformationCssName(\StructType\ORFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\ORFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\ORFkType $geoLocationName
     * @return \StructType\ORPhone
     */
    public function setGeoLocationName(\StructType\ORFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \StructType\ORFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \StructType\ORFkType $geoLocationFilterName
     * @return \StructType\ORPhone
     */
    public function setGeoLocationFilterName(\StructType\ORFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \StructType\Lines $lines
     * @return \StructType\ORPhone
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \StructType\ORFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \StructType\ORFkType $phoneTemplateName
     * @return \StructType\ORPhone
     */
    public function setPhoneTemplateName(\StructType\ORFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return \StructType\ORFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param \StructType\ORFkType $primaryPhoneName
     * @return \StructType\ORPhone
     */
    public function setPrimaryPhoneName(\StructType\ORFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return \StructType\ORFkType|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @param \StructType\ORFkType $ringSettingIdleBlfAudibleAlert
     * @return \StructType\ORPhone
     */
    public function setRingSettingIdleBlfAudibleAlert(\StructType\ORFkType $ringSettingIdleBlfAudibleAlert = null)
    {
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return \StructType\ORFkType|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @param \StructType\ORFkType $ringSettingBusyBlfAudibleAlert
     * @return \StructType\ORPhone
     */
    public function setRingSettingBusyBlfAudibleAlert(\StructType\ORFkType $ringSettingBusyBlfAudibleAlert = null)
    {
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \StructType\ORPhone
     */
    public function setBlfDirectedCallParks(\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \StructType\AddOnModules $addOnModules
     * @return \StructType\ORPhone
     */
    public function setAddOnModules(\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return \StructType\ORFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param \StructType\ORFkType $userLocale
     * @return \StructType\ORPhone
     */
    public function setUserLocale(\StructType\ORFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return \StructType\ORFkType|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param \StructType\ORFkType $networkLocale
     * @return \StructType\ORPhone
     */
    public function setNetworkLocale(\StructType\ORFkType $networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\ORPhone
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \StructType\ORFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \StructType\ORFkType $softkeyTemplateName
     * @return \StructType\ORPhone
     */
    public function setSoftkeyTemplateName(\StructType\ORFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return \StructType\ORFkType|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param \StructType\ORFkType $defaultProfileName
     * @return \StructType\ORPhone
     */
    public function setDefaultProfileName(\StructType\ORFkType $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return \StructType\ORFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param \StructType\ORFkType $singleButtonBarge
     * @return \StructType\ORPhone
     */
    public function setSingleButtonBarge(\StructType\ORFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return \StructType\ORFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param \StructType\ORFkType $joinAcrossLines
     * @return \StructType\ORPhone
     */
    public function setJoinAcrossLines(\StructType\ORFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return \StructType\ORFkType|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @param \StructType\ORFkType $builtInBridgeStatus
     * @return \StructType\ORPhone
     */
    public function setBuiltInBridgeStatus(\StructType\ORFkType $builtInBridgeStatus = null)
    {
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return \StructType\ORFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param \StructType\ORFkType $callInfoPrivacyStatus
     * @return \StructType\ORPhone
     */
    public function setCallInfoPrivacyStatus(\StructType\ORFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return \StructType\ORFkType|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param \StructType\ORFkType $ownerUserName
     * @return \StructType\ORPhone
     */
    public function setOwnerUserName(\StructType\ORFkType $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return \StructType\ORFkType|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param \StructType\ORFkType $packetCaptureMode
     * @return \StructType\ORPhone
     */
    public function setPacketCaptureMode(\StructType\ORFkType $packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \StructType\ORFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \StructType\ORFkType $subscribeCallingSearchSpaceName
     * @return \StructType\ORPhone
     */
    public function setSubscribeCallingSearchSpaceName(\StructType\ORFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return \StructType\ORFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param \StructType\ORFkType $rerouteCallingSearchSpaceName
     * @return \StructType\ORPhone
     */
    public function setRerouteCallingSearchSpaceName(\StructType\ORFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\ORFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\ORFkType $presenceGroupName
     * @return \StructType\ORPhone
     */
    public function setPresenceGroupName(\StructType\ORFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return \StructType\ORFkType|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @param \StructType\ORFkType $certificateOperation
     * @return \StructType\ORPhone
     */
    public function setCertificateOperation(\StructType\ORFkType $certificateOperation = null)
    {
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return \StructType\ORFkType|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param \StructType\ORFkType $authenticationMode
     * @return \StructType\ORPhone
     */
    public function setAuthenticationMode(\StructType\ORFkType $authenticationMode = null)
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return \StructType\ORFkType|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param \StructType\ORFkType $keySize
     * @return \StructType\ORPhone
     */
    public function setKeySize(\StructType\ORFkType $keySize = null)
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return \StructType\ORFkType|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @param \StructType\ORFkType $deviceMobilityMode
     * @return \StructType\ORPhone
     */
    public function setDeviceMobilityMode(\StructType\ORFkType $deviceMobilityMode = null)
    {
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get dndOption value
     * @return \StructType\ORFkType|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param \StructType\ORFkType $dndOption
     * @return \StructType\ORPhone
     */
    public function setDndOption(\StructType\ORFkType $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return \StructType\ORFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param \StructType\ORFkType $dndRingSetting
     * @return \StructType\ORPhone
     */
    public function setDndRingSetting(\StructType\ORFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return \StructType\ORFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param \StructType\ORFkType $mobilityUserIdName
     * @return \StructType\ORPhone
     */
    public function setMobilityUserIdName(\StructType\ORFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return \StructType\ORFkType|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @param \StructType\ORFkType $phoneSuite
     * @return \StructType\ORPhone
     */
    public function setPhoneSuite(\StructType\ORFkType $phoneSuite = null)
    {
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return \StructType\ORFkType|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param \StructType\ORFkType $phoneServiceDisplay
     * @return \StructType\ORPhone
     */
    public function setPhoneServiceDisplay(\StructType\ORFkType $phoneServiceDisplay = null)
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return \StructType\ORFkType|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @param \StructType\ORFkType $mtpPreferedCodec
     * @return \StructType\ORPhone
     */
    public function setMtpPreferedCodec(\StructType\ORFkType $mtpPreferedCodec = null)
    {
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return \StructType\ORFkType|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param \StructType\ORFkType $dialRulesName
     * @return \StructType\ORPhone
     */
    public function setDialRulesName(\StructType\ORFkType $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return \StructType\ORFkType|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @param \StructType\ORFkType $outboundCallRollover
     * @return \StructType\ORPhone
     */
    public function setOutboundCallRollover(\StructType\ORFkType $outboundCallRollover = null)
    {
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return \StructType\ORFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param \StructType\ORFkType $alwaysUsePrimeLine
     * @return \StructType\ORPhone
     */
    public function setAlwaysUsePrimeLine(\StructType\ORFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return \StructType\ORFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param \StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\ORPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(\StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \StructType\ORFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \StructType\ORFkType $featureControlPolicy
     * @return \StructType\ORPhone
     */
    public function setFeatureControlPolicy(\StructType\ORFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return \StructType\ORFkType|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @param \StructType\ORFkType $deviceTrustMode
     * @return \StructType\ORPhone
     */
    public function setDeviceTrustMode(\StructType\ORFkType $deviceTrustMode = null)
    {
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\ORPhone
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * @return \StructType\ORFkType|null
     */
    public function getCgpnIngressDN()
    {
        return $this->cgpnIngressDN;
    }
    /**
     * Set cgpnIngressDN value
     * @param \StructType\ORFkType $cgpnIngressDN
     * @return \StructType\ORPhone
     */
    public function setCgpnIngressDN(\StructType\ORFkType $cgpnIngressDN = null)
    {
        $this->cgpnIngressDN = $cgpnIngressDN;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * @return \StructType\ORFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return $this->wifiHotspotProfile;
    }
    /**
     * Set wifiHotspotProfile value
     * @param \StructType\ORFkType $wifiHotspotProfile
     * @return \StructType\ORPhone
     */
    public function setWifiHotspotProfile(\StructType\ORFkType $wifiHotspotProfile = null)
    {
        $this->wifiHotspotProfile = $wifiHotspotProfile;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return \StructType\ORFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param \StructType\ORFkType $wirelessLanProfileGroup
     * @return \StructType\ORPhone
     */
    public function setWirelessLanProfileGroup(\StructType\ORFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\ORPhone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORPhone
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
