<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORDirectoryUri StructType
 * @subpackage Structs
 */
class ORDirectoryUri extends AbstractStructBase
{
    /**
     * The partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORDirectoryUri
     * @uses ORDirectoryUri::setPartition()
     * @uses ORDirectoryUri::setUuid()
     * @param \StructType\ORFkType $partition
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $partition = null, $uuid = null)
    {
        $this
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get partition value
     * @return \StructType\ORFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param \StructType\ORFkType $partition
     * @return \StructType\ORDirectoryUri
     */
    public function setPartition(\StructType\ORFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORDirectoryUri
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
