<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORDeviceProfile StructType
 * @subpackage Structs
 */
class ORDeviceProfile extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $protocolSide;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $preemption;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $phoneTemplateName;
    /**
     * The blfDirectedCallParks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $loginUserId;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $dndRingSetting;
    /**
     * The emccCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORDeviceProfile
     * @uses ORDeviceProfile::setProduct()
     * @uses ORDeviceProfile::setClass()
     * @uses ORDeviceProfile::setProtocol()
     * @uses ORDeviceProfile::setProtocolSide()
     * @uses ORDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses ORDeviceProfile::setMlppIndicationStatus()
     * @uses ORDeviceProfile::setPreemption()
     * @uses ORDeviceProfile::setLines()
     * @uses ORDeviceProfile::setPhoneTemplateName()
     * @uses ORDeviceProfile::setBlfDirectedCallParks()
     * @uses ORDeviceProfile::setAddOnModules()
     * @uses ORDeviceProfile::setUserLocale()
     * @uses ORDeviceProfile::setSingleButtonBarge()
     * @uses ORDeviceProfile::setJoinAcrossLines()
     * @uses ORDeviceProfile::setLoginUserId()
     * @uses ORDeviceProfile::setDndOption()
     * @uses ORDeviceProfile::setDndRingSetting()
     * @uses ORDeviceProfile::setEmccCallingSearchSpace()
     * @uses ORDeviceProfile::setAlwaysUsePrimeLine()
     * @uses ORDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses ORDeviceProfile::setSoftkeyTemplateName()
     * @uses ORDeviceProfile::setCallInfoPrivacyStatus()
     * @uses ORDeviceProfile::setServices()
     * @uses ORDeviceProfile::setFeatureControlPolicy()
     * @uses ORDeviceProfile::setCtiid()
     * @uses ORDeviceProfile::setUuid()
     * @param \StructType\ORFkType $product
     * @param \StructType\ORFkType $class
     * @param \StructType\ORFkType $protocol
     * @param \StructType\ORFkType $protocolSide
     * @param \StructType\ORFkType $userHoldMohAudioSourceId
     * @param \StructType\ORFkType $mlppIndicationStatus
     * @param \StructType\ORFkType $preemption
     * @param \StructType\Lines $lines
     * @param \StructType\ORFkType $phoneTemplateName
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \StructType\AddOnModules $addOnModules
     * @param \StructType\ORFkType $userLocale
     * @param \StructType\ORFkType $singleButtonBarge
     * @param \StructType\ORFkType $joinAcrossLines
     * @param \StructType\ORFkType $loginUserId
     * @param \StructType\ORFkType $dndOption
     * @param \StructType\ORFkType $dndRingSetting
     * @param \StructType\ORFkType $emccCallingSearchSpace
     * @param \StructType\ORFkType $alwaysUsePrimeLine
     * @param \StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @param \StructType\ORFkType $softkeyTemplateName
     * @param \StructType\ORFkType $callInfoPrivacyStatus
     * @param \StructType\Services $services
     * @param \StructType\ORFkType $featureControlPolicy
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $product = null, \StructType\ORFkType $class = null, \StructType\ORFkType $protocol = null, \StructType\ORFkType $protocolSide = null, \StructType\ORFkType $userHoldMohAudioSourceId = null, \StructType\ORFkType $mlppIndicationStatus = null, \StructType\ORFkType $preemption = null, \StructType\Lines $lines = null, \StructType\ORFkType $phoneTemplateName = null, \StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \StructType\AddOnModules $addOnModules = null, \StructType\ORFkType $userLocale = null, \StructType\ORFkType $singleButtonBarge = null, \StructType\ORFkType $joinAcrossLines = null, \StructType\ORFkType $loginUserId = null, \StructType\ORFkType $dndOption = null, \StructType\ORFkType $dndRingSetting = null, \StructType\ORFkType $emccCallingSearchSpace = null, \StructType\ORFkType $alwaysUsePrimeLine = null, \StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage = null, \StructType\ORFkType $softkeyTemplateName = null, \StructType\ORFkType $callInfoPrivacyStatus = null, \StructType\Services $services = null, \StructType\ORFkType $featureControlPolicy = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setServices($services)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return \StructType\ORFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ORFkType $product
     * @return \StructType\ORDeviceProfile
     */
    public function setProduct(\StructType\ORFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\ORFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\ORFkType $class
     * @return \StructType\ORDeviceProfile
     */
    public function setClass(\StructType\ORFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return \StructType\ORFkType|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param \StructType\ORFkType $protocol
     * @return \StructType\ORDeviceProfile
     */
    public function setProtocol(\StructType\ORFkType $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return \StructType\ORFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param \StructType\ORFkType $protocolSide
     * @return \StructType\ORDeviceProfile
     */
    public function setProtocolSide(\StructType\ORFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \StructType\ORFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \StructType\ORFkType $userHoldMohAudioSourceId
     * @return \StructType\ORDeviceProfile
     */
    public function setUserHoldMohAudioSourceId(\StructType\ORFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return \StructType\ORFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param \StructType\ORFkType $mlppIndicationStatus
     * @return \StructType\ORDeviceProfile
     */
    public function setMlppIndicationStatus(\StructType\ORFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return \StructType\ORFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param \StructType\ORFkType $preemption
     * @return \StructType\ORDeviceProfile
     */
    public function setPreemption(\StructType\ORFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \StructType\Lines $lines
     * @return \StructType\ORDeviceProfile
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \StructType\ORFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \StructType\ORFkType $phoneTemplateName
     * @return \StructType\ORDeviceProfile
     */
    public function setPhoneTemplateName(\StructType\ORFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \StructType\ORDeviceProfile
     */
    public function setBlfDirectedCallParks(\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \StructType\AddOnModules $addOnModules
     * @return \StructType\ORDeviceProfile
     */
    public function setAddOnModules(\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return \StructType\ORFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param \StructType\ORFkType $userLocale
     * @return \StructType\ORDeviceProfile
     */
    public function setUserLocale(\StructType\ORFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return \StructType\ORFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param \StructType\ORFkType $singleButtonBarge
     * @return \StructType\ORDeviceProfile
     */
    public function setSingleButtonBarge(\StructType\ORFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return \StructType\ORFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param \StructType\ORFkType $joinAcrossLines
     * @return \StructType\ORDeviceProfile
     */
    public function setJoinAcrossLines(\StructType\ORFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return \StructType\ORFkType|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param \StructType\ORFkType $loginUserId
     * @return \StructType\ORDeviceProfile
     */
    public function setLoginUserId(\StructType\ORFkType $loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get dndOption value
     * @return \StructType\ORFkType|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param \StructType\ORFkType $dndOption
     * @return \StructType\ORDeviceProfile
     */
    public function setDndOption(\StructType\ORFkType $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return \StructType\ORFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param \StructType\ORFkType $dndRingSetting
     * @return \StructType\ORDeviceProfile
     */
    public function setDndRingSetting(\StructType\ORFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * @return \StructType\ORFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return $this->emccCallingSearchSpace;
    }
    /**
     * Set emccCallingSearchSpace value
     * @param \StructType\ORFkType $emccCallingSearchSpace
     * @return \StructType\ORDeviceProfile
     */
    public function setEmccCallingSearchSpace(\StructType\ORFkType $emccCallingSearchSpace = null)
    {
        $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return \StructType\ORFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param \StructType\ORFkType $alwaysUsePrimeLine
     * @return \StructType\ORDeviceProfile
     */
    public function setAlwaysUsePrimeLine(\StructType\ORFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return \StructType\ORFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param \StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\ORDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(\StructType\ORFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \StructType\ORFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \StructType\ORFkType $softkeyTemplateName
     * @return \StructType\ORDeviceProfile
     */
    public function setSoftkeyTemplateName(\StructType\ORFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return \StructType\ORFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param \StructType\ORFkType $callInfoPrivacyStatus
     * @return \StructType\ORDeviceProfile
     */
    public function setCallInfoPrivacyStatus(\StructType\ORFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\ORDeviceProfile
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \StructType\ORFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \StructType\ORFkType $featureControlPolicy
     * @return \StructType\ORDeviceProfile
     */
    public function setFeatureControlPolicy(\StructType\ORFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\ORDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORDeviceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
