<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVoiceMailPort StructType
 * @subpackage Structs
 */
class LVoiceMailPort extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The dnPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dnPattern;
    /**
     * The callerIdDisplay
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDisplay;
    /**
     * The callerIdDisplayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDisplayAscii;
    /**
     * The externalMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalMask;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVoiceMailPort
     * @uses LVoiceMailPort::setName()
     * @uses LVoiceMailPort::setDescription()
     * @uses LVoiceMailPort::setProduct()
     * @uses LVoiceMailPort::setModel()
     * @uses LVoiceMailPort::setClass()
     * @uses LVoiceMailPort::setProtocol()
     * @uses LVoiceMailPort::setProtocolSide()
     * @uses LVoiceMailPort::setCallingSearchSpaceName()
     * @uses LVoiceMailPort::setDevicePoolName()
     * @uses LVoiceMailPort::setCommonDeviceConfigName()
     * @uses LVoiceMailPort::setLocationName()
     * @uses LVoiceMailPort::setPreemption()
     * @uses LVoiceMailPort::setUseTrustedRelayPoint()
     * @uses LVoiceMailPort::setSecurityProfileName()
     * @uses LVoiceMailPort::setGeoLocationName()
     * @uses LVoiceMailPort::setAutomatedAlternateRoutingCssName()
     * @uses LVoiceMailPort::setDnPattern()
     * @uses LVoiceMailPort::setCallerIdDisplay()
     * @uses LVoiceMailPort::setCallerIdDisplayAscii()
     * @uses LVoiceMailPort::setExternalMask()
     * @uses LVoiceMailPort::setCtiid()
     * @uses LVoiceMailPort::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param \StructType\XFkType $locationName
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param \StructType\XFkType $securityProfileName
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param string $dnPattern
     * @param string $callerIdDisplay
     * @param string $callerIdDisplayAscii
     * @param string $externalMask
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, \StructType\XFkType $locationName = null, $preemption = null, $useTrustedRelayPoint = null, \StructType\XFkType $securityProfileName = null, \StructType\XFkType $geoLocationName = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, $dnPattern = null, $callerIdDisplay = null, $callerIdDisplayAscii = null, $externalMask = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setGeoLocationName($geoLocationName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setDnPattern($dnPattern)
            ->setCallerIdDisplay($callerIdDisplay)
            ->setCallerIdDisplayAscii($callerIdDisplayAscii)
            ->setExternalMask($externalMask)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LVoiceMailPort
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LVoiceMailPort
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\LVoiceMailPort
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \EnumType\XModel::valueIsValid()
     * @uses \EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \StructType\LVoiceMailPort
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XModel', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\XClass::valueIsValid()
     * @uses \EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\LVoiceMailPort
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\LVoiceMailPort
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \EnumType\XProtocolSide::valueIsValid()
     * @uses \EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \StructType\LVoiceMailPort
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProtocolSide', is_array($protocolSide) ? implode(', ', $protocolSide) : var_export($protocolSide, true), implode(', ', \EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\LVoiceMailPort
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\LVoiceMailPort
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\LVoiceMailPort
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\LVoiceMailPort
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\LVoiceMailPort
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\LVoiceMailPort
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \StructType\XFkType $securityProfileName
     * @return \StructType\LVoiceMailPort
     */
    public function setSecurityProfileName(\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\LVoiceMailPort
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\LVoiceMailPort
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get dnPattern value
     * @return string|null
     */
    public function getDnPattern()
    {
        return $this->dnPattern;
    }
    /**
     * Set dnPattern value
     * @param string $dnPattern
     * @return \StructType\LVoiceMailPort
     */
    public function setDnPattern($dnPattern = null)
    {
        // validation for constraint: string
        if (!is_null($dnPattern) && !is_string($dnPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnPattern, true), gettype($dnPattern)), __LINE__);
        }
        $this->dnPattern = $dnPattern;
        return $this;
    }
    /**
     * Get callerIdDisplay value
     * @return string|null
     */
    public function getCallerIdDisplay()
    {
        return $this->callerIdDisplay;
    }
    /**
     * Set callerIdDisplay value
     * @param string $callerIdDisplay
     * @return \StructType\LVoiceMailPort
     */
    public function setCallerIdDisplay($callerIdDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDisplay) && !is_string($callerIdDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDisplay, true), gettype($callerIdDisplay)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($callerIdDisplay) && mb_strlen($callerIdDisplay) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($callerIdDisplay)), __LINE__);
        }
        $this->callerIdDisplay = $callerIdDisplay;
        return $this;
    }
    /**
     * Get callerIdDisplayAscii value
     * @return string|null
     */
    public function getCallerIdDisplayAscii()
    {
        return $this->callerIdDisplayAscii;
    }
    /**
     * Set callerIdDisplayAscii value
     * @param string $callerIdDisplayAscii
     * @return \StructType\LVoiceMailPort
     */
    public function setCallerIdDisplayAscii($callerIdDisplayAscii = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDisplayAscii) && !is_string($callerIdDisplayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDisplayAscii, true), gettype($callerIdDisplayAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerIdDisplayAscii) && mb_strlen($callerIdDisplayAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerIdDisplayAscii)), __LINE__);
        }
        $this->callerIdDisplayAscii = $callerIdDisplayAscii;
        return $this;
    }
    /**
     * Get externalMask value
     * @return string|null
     */
    public function getExternalMask()
    {
        return $this->externalMask;
    }
    /**
     * Set externalMask value
     * @param string $externalMask
     * @return \StructType\LVoiceMailPort
     */
    public function setExternalMask($externalMask = null)
    {
        // validation for constraint: string
        if (!is_null($externalMask) && !is_string($externalMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalMask, true), gettype($externalMask)), __LINE__);
        }
        $this->externalMask = $externalMask;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\LVoiceMailPort
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LVoiceMailPort
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
