<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LUserPhoneAssociation StructType
 * @subpackage Structs
 */
class LUserPhoneAssociation extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The dnCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $dnCssName;
    /**
     * The phoneCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $phoneCssName;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164Mask;
    /**
     * The extension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extension;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The enableExtensionMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The DirectoryURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DirectoryURI;
    /**
     * The DirectoryNumberURIPartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $DirectoryNumberURIPartition;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LUserPhoneAssociation
     * @uses LUserPhoneAssociation::setUserId()
     * @uses LUserPhoneAssociation::setPassword()
     * @uses LUserPhoneAssociation::setPin()
     * @uses LUserPhoneAssociation::setLastName()
     * @uses LUserPhoneAssociation::setMiddleName()
     * @uses LUserPhoneAssociation::setFirstName()
     * @uses LUserPhoneAssociation::setProductType()
     * @uses LUserPhoneAssociation::setName()
     * @uses LUserPhoneAssociation::setDnCssName()
     * @uses LUserPhoneAssociation::setPhoneCssName()
     * @uses LUserPhoneAssociation::setE164Mask()
     * @uses LUserPhoneAssociation::setExtension()
     * @uses LUserPhoneAssociation::setRoutePartitionName()
     * @uses LUserPhoneAssociation::setVoiceMailProfileName()
     * @uses LUserPhoneAssociation::setEnableExtensionMobility()
     * @uses LUserPhoneAssociation::setDirectoryURI()
     * @uses LUserPhoneAssociation::setDirectoryNumberURIPartition()
     * @uses LUserPhoneAssociation::setUuid()
     * @param string $userId
     * @param string $password
     * @param string $pin
     * @param string $lastName
     * @param string $middleName
     * @param string $firstName
     * @param string $productType
     * @param string $name
     * @param \StructType\XFkType $dnCssName
     * @param \StructType\XFkType $phoneCssName
     * @param string $e164Mask
     * @param string $extension
     * @param \StructType\XFkType $routePartitionName
     * @param \StructType\XFkType $voiceMailProfileName
     * @param string $enableExtensionMobility
     * @param string $directoryURI
     * @param \StructType\XFkType $directoryNumberURIPartition
     * @param string $uuid
     */
    public function __construct($userId = null, $password = null, $pin = null, $lastName = null, $middleName = null, $firstName = null, $productType = null, $name = null, \StructType\XFkType $dnCssName = null, \StructType\XFkType $phoneCssName = null, $e164Mask = null, $extension = null, \StructType\XFkType $routePartitionName = null, \StructType\XFkType $voiceMailProfileName = null, $enableExtensionMobility = null, $directoryURI = null, \StructType\XFkType $directoryNumberURIPartition = null, $uuid = null)
    {
        $this
            ->setUserId($userId)
            ->setPassword($password)
            ->setPin($pin)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setFirstName($firstName)
            ->setProductType($productType)
            ->setName($name)
            ->setDnCssName($dnCssName)
            ->setPhoneCssName($phoneCssName)
            ->setE164Mask($e164Mask)
            ->setExtension($extension)
            ->setRoutePartitionName($routePartitionName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setDirectoryURI($directoryURI)
            ->setDirectoryNumberURIPartition($directoryNumberURIPartition)
            ->setUuid($uuid);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\LUserPhoneAssociation
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\LUserPhoneAssociation
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pin
     * @return \StructType\LUserPhoneAssociation
     */
    public function setPin($pin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($pin) ? implode(', ', $pin) : var_export($pin, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\LUserPhoneAssociation
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\LUserPhoneAssociation
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\LUserPhoneAssociation
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses \EnumType\XModel::valueIsValid()
     * @uses \EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\LUserPhoneAssociation
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XModel::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XModel', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LUserPhoneAssociation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dnCssName value
     * @return \StructType\XFkType|null
     */
    public function getDnCssName()
    {
        return $this->dnCssName;
    }
    /**
     * Set dnCssName value
     * @param \StructType\XFkType $dnCssName
     * @return \StructType\LUserPhoneAssociation
     */
    public function setDnCssName(\StructType\XFkType $dnCssName = null)
    {
        $this->dnCssName = $dnCssName;
        return $this;
    }
    /**
     * Get phoneCssName value
     * @return \StructType\XFkType|null
     */
    public function getPhoneCssName()
    {
        return $this->phoneCssName;
    }
    /**
     * Set phoneCssName value
     * @param \StructType\XFkType $phoneCssName
     * @return \StructType\LUserPhoneAssociation
     */
    public function setPhoneCssName(\StructType\XFkType $phoneCssName = null)
    {
        $this->phoneCssName = $phoneCssName;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \StructType\LUserPhoneAssociation
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e164Mask, true), gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \StructType\LUserPhoneAssociation
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\LUserPhoneAssociation
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \StructType\XFkType $voiceMailProfileName
     * @return \StructType\LUserPhoneAssociation
     */
    public function setVoiceMailProfileName(\StructType\XFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \StructType\LUserPhoneAssociation
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableExtensionMobility, true), gettype($enableExtensionMobility)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableExtensionMobility, true)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get DirectoryURI value
     * @return string|null
     */
    public function getDirectoryURI()
    {
        return $this->DirectoryURI;
    }
    /**
     * Set DirectoryURI value
     * @param string $directoryURI
     * @return \StructType\LUserPhoneAssociation
     */
    public function setDirectoryURI($directoryURI = null)
    {
        // validation for constraint: string
        if (!is_null($directoryURI) && !is_string($directoryURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryURI, true), gettype($directoryURI)), __LINE__);
        }
        $this->DirectoryURI = $directoryURI;
        return $this;
    }
    /**
     * Get DirectoryNumberURIPartition value
     * @return \StructType\XFkType|null
     */
    public function getDirectoryNumberURIPartition()
    {
        return $this->DirectoryNumberURIPartition;
    }
    /**
     * Set DirectoryNumberURIPartition value
     * @param \StructType\XFkType $directoryNumberURIPartition
     * @return \StructType\LUserPhoneAssociation
     */
    public function setDirectoryNumberURIPartition(\StructType\XFkType $directoryNumberURIPartition = null)
    {
        $this->DirectoryNumberURIPartition = $directoryNumberURIPartition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LUserPhoneAssociation
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
