<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTvsCertificate StructType
 * @subpackage Structs
 */
class LTvsCertificate extends AbstractStructBase
{
    /**
     * The subjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subjectName;
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serialNumber;
    /**
     * The timeToLive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $timeToLive;
    /**
     * The ipv4Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipv4Address;
    /**
     * The ipv6Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipv6Address;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LTvsCertificate
     * @uses LTvsCertificate::setSubjectName()
     * @uses LTvsCertificate::setIssuerName()
     * @uses LTvsCertificate::setSerialNumber()
     * @uses LTvsCertificate::setTimeToLive()
     * @uses LTvsCertificate::setIpv4Address()
     * @uses LTvsCertificate::setIpv6Address()
     * @uses LTvsCertificate::setUuid()
     * @param string $subjectName
     * @param string $issuerName
     * @param string $serialNumber
     * @param int $timeToLive
     * @param string $ipv4Address
     * @param string $ipv6Address
     * @param string $uuid
     */
    public function __construct($subjectName = null, $issuerName = null, $serialNumber = null, $timeToLive = null, $ipv4Address = null, $ipv6Address = null, $uuid = null)
    {
        $this
            ->setSubjectName($subjectName)
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setTimeToLive($timeToLive)
            ->setIpv4Address($ipv4Address)
            ->setIpv6Address($ipv6Address)
            ->setUuid($uuid);
    }
    /**
     * Get subjectName value
     * @return string|null
     */
    public function getSubjectName()
    {
        return $this->subjectName;
    }
    /**
     * Set subjectName value
     * @param string $subjectName
     * @return \StructType\LTvsCertificate
     */
    public function setSubjectName($subjectName = null)
    {
        // validation for constraint: string
        if (!is_null($subjectName) && !is_string($subjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subjectName, true), gettype($subjectName)), __LINE__);
        }
        $this->subjectName = $subjectName;
        return $this;
    }
    /**
     * Get issuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \StructType\LTvsCertificate
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerName, true), gettype($issuerName)), __LINE__);
        }
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \StructType\LTvsCertificate
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get timeToLive value
     * @return int|null
     */
    public function getTimeToLive()
    {
        return $this->timeToLive;
    }
    /**
     * Set timeToLive value
     * @param int $timeToLive
     * @return \StructType\LTvsCertificate
     */
    public function setTimeToLive($timeToLive = null)
    {
        // validation for constraint: int
        if (!is_null($timeToLive) && !(is_int($timeToLive) || ctype_digit($timeToLive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeToLive, true), gettype($timeToLive)), __LINE__);
        }
        $this->timeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get ipv4Address value
     * @return string|null
     */
    public function getIpv4Address()
    {
        return $this->ipv4Address;
    }
    /**
     * Set ipv4Address value
     * @param string $ipv4Address
     * @return \StructType\LTvsCertificate
     */
    public function setIpv4Address($ipv4Address = null)
    {
        // validation for constraint: string
        if (!is_null($ipv4Address) && !is_string($ipv4Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipv4Address, true), gettype($ipv4Address)), __LINE__);
        }
        $this->ipv4Address = $ipv4Address;
        return $this;
    }
    /**
     * Get ipv6Address value
     * @return string|null
     */
    public function getIpv6Address()
    {
        return $this->ipv6Address;
    }
    /**
     * Set ipv6Address value
     * @param string $ipv6Address
     * @return \StructType\LTvsCertificate
     */
    public function setIpv6Address($ipv6Address = null)
    {
        // validation for constraint: string
        if (!is_null($ipv6Address) && !is_string($ipv6Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipv6Address, true), gettype($ipv6Address)), __LINE__);
        }
        $this->ipv6Address = $ipv6Address;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LTvsCertificate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
