<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSrst StructType
 * @subpackage Structs
 */
class LSrst extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The SipNetwork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SipNetwork;
    /**
     * The SipPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SipPort;
    /**
     * The srstCertificatePort
     * Meta information extracted from the WSDL
     * - documentation: Read-Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $srstCertificatePort;
    /**
     * The isSecure
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isSecure;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSrst
     * @uses LSrst::setName()
     * @uses LSrst::setPort()
     * @uses LSrst::setIpAddress()
     * @uses LSrst::setSipNetwork()
     * @uses LSrst::setSipPort()
     * @uses LSrst::setSrstCertificatePort()
     * @uses LSrst::setIsSecure()
     * @uses LSrst::setUuid()
     * @param string $name
     * @param string $port
     * @param string $ipAddress
     * @param string $sipNetwork
     * @param string $sipPort
     * @param string $srstCertificatePort
     * @param string $isSecure
     * @param string $uuid
     */
    public function __construct($name = null, $port = null, $ipAddress = null, $sipNetwork = null, $sipPort = null, $srstCertificatePort = null, $isSecure = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setPort($port)
            ->setIpAddress($ipAddress)
            ->setSipNetwork($sipNetwork)
            ->setSipPort($sipPort)
            ->setSrstCertificatePort($srstCertificatePort)
            ->setIsSecure($isSecure)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LSrst
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\LSrst
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\LSrst
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get SipNetwork value
     * @return string|null
     */
    public function getSipNetwork()
    {
        return $this->SipNetwork;
    }
    /**
     * Set SipNetwork value
     * @param string $sipNetwork
     * @return \StructType\LSrst
     */
    public function setSipNetwork($sipNetwork = null)
    {
        // validation for constraint: string
        if (!is_null($sipNetwork) && !is_string($sipNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sipNetwork, true), gettype($sipNetwork)), __LINE__);
        }
        $this->SipNetwork = $sipNetwork;
        return $this;
    }
    /**
     * Get SipPort value
     * @return string|null
     */
    public function getSipPort()
    {
        return $this->SipPort;
    }
    /**
     * Set SipPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPort
     * @return \StructType\LSrst
     */
    public function setSipPort($sipPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sipPort) ? implode(', ', $sipPort) : var_export($sipPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->SipPort = $sipPort;
        return $this;
    }
    /**
     * Get srstCertificatePort value
     * @return string|null
     */
    public function getSrstCertificatePort()
    {
        return $this->srstCertificatePort;
    }
    /**
     * Set srstCertificatePort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $srstCertificatePort
     * @return \StructType\LSrst
     */
    public function setSrstCertificatePort($srstCertificatePort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($srstCertificatePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($srstCertificatePort) ? implode(', ', $srstCertificatePort) : var_export($srstCertificatePort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->srstCertificatePort = $srstCertificatePort;
        return $this;
    }
    /**
     * Get isSecure value
     * @return string|null
     */
    public function getIsSecure()
    {
        return $this->isSecure;
    }
    /**
     * Set isSecure value
     * @param string $isSecure
     * @return \StructType\LSrst
     */
    public function setIsSecure($isSecure = null)
    {
        // validation for constraint: string
        if (!is_null($isSecure) && !is_string($isSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isSecure, true), gettype($isSecure)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isSecure) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isSecure, true)), __LINE__);
        }
        $this->isSecure = $isSecure;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LSrst
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
