<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSoftKeyTemplate StructType
 * @subpackage Structs
 */
class LSoftKeyTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The baseSoftkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $baseSoftkeyTemplateName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSoftKeyTemplate
     * @uses LSoftKeyTemplate::setName()
     * @uses LSoftKeyTemplate::setDescription()
     * @uses LSoftKeyTemplate::setBaseSoftkeyTemplateName()
     * @uses LSoftKeyTemplate::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $baseSoftkeyTemplateName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $baseSoftkeyTemplateName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setBaseSoftkeyTemplateName($baseSoftkeyTemplateName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LSoftKeyTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name) && mb_strlen($name) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LSoftKeyTemplate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($description) && mb_strlen($description) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get baseSoftkeyTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getBaseSoftkeyTemplateName()
    {
        return $this->baseSoftkeyTemplateName;
    }
    /**
     * Set baseSoftkeyTemplateName value
     * @param \StructType\XFkType $baseSoftkeyTemplateName
     * @return \StructType\LSoftKeyTemplate
     */
    public function setBaseSoftkeyTemplateName(\StructType\XFkType $baseSoftkeyTemplateName = null)
    {
        $this->baseSoftkeyTemplateName = $baseSoftkeyTemplateName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LSoftKeyTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
