<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteListMember StructType
 * @subpackage Structs
 */
class LRouteListMember extends AbstractStructBase
{
    /**
     * The routeGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routeGroupName;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The dialPlanWizardGenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The useFullyQualifiedCallingPartyNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useFullyQualifiedCallingPartyNumber;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteListMember
     * @uses LRouteListMember::setRouteGroupName()
     * @uses LRouteListMember::setSelectionOrder()
     * @uses LRouteListMember::setCalledPartyTransformationMask()
     * @uses LRouteListMember::setCallingPartyTransformationMask()
     * @uses LRouteListMember::setDialPlanWizardGenId()
     * @uses LRouteListMember::setDigitDiscardInstructionName()
     * @uses LRouteListMember::setCallingPartyPrefixDigits()
     * @uses LRouteListMember::setPrefixDigitsOut()
     * @uses LRouteListMember::setUseFullyQualifiedCallingPartyNumber()
     * @uses LRouteListMember::setCallingPartyNumberingPlan()
     * @uses LRouteListMember::setCallingPartyNumberType()
     * @uses LRouteListMember::setCalledPartyNumberingPlan()
     * @uses LRouteListMember::setCalledPartyNumberType()
     * @uses LRouteListMember::setUuid()
     * @param \StructType\XFkType $routeGroupName
     * @param string $selectionOrder
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $dialPlanWizardGenId
     * @param \StructType\XFkType $digitDiscardInstructionName
     * @param string $callingPartyPrefixDigits
     * @param string $prefixDigitsOut
     * @param string $useFullyQualifiedCallingPartyNumber
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $routeGroupName = null, $selectionOrder = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $dialPlanWizardGenId = null, \StructType\XFkType $digitDiscardInstructionName = null, $callingPartyPrefixDigits = null, $prefixDigitsOut = null, $useFullyQualifiedCallingPartyNumber = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, $uuid = null)
    {
        $this
            ->setRouteGroupName($routeGroupName)
            ->setSelectionOrder($selectionOrder)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setUuid($uuid);
    }
    /**
     * Get routeGroupName value
     * @return \StructType\XFkType|null
     */
    public function getRouteGroupName()
    {
        return $this->routeGroupName;
    }
    /**
     * Set routeGroupName value
     * @param \StructType\XFkType $routeGroupName
     * @return \StructType\LRouteListMember
     */
    public function setRouteGroupName(\StructType\XFkType $routeGroupName = null)
    {
        $this->routeGroupName = $routeGroupName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\LRouteListMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \StructType\LRouteListMember
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyTransformationMask, true), gettype($calledPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($calledPartyTransformationMask) && mb_strlen($calledPartyTransformationMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($calledPartyTransformationMask)), __LINE__);
        }
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \StructType\LRouteListMember
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyTransformationMask, true), gettype($callingPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyTransformationMask) && mb_strlen($callingPartyTransformationMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return \StructType\LRouteListMember
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dialPlanWizardGenId) ? implode(', ', $dialPlanWizardGenId) : var_export($dialPlanWizardGenId, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \StructType\XFkType $digitDiscardInstructionName
     * @return \StructType\LRouteListMember
     */
    public function setDigitDiscardInstructionName(\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \StructType\LRouteListMember
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyPrefixDigits, true), gettype($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyPrefixDigits) && mb_strlen($callingPartyPrefixDigits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \StructType\LRouteListMember
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigitsOut, true), gettype($prefixDigitsOut)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prefixDigitsOut) && mb_strlen($prefixDigitsOut) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get useFullyQualifiedCallingPartyNumber value
     * @return string|null
     */
    public function getUseFullyQualifiedCallingPartyNumber()
    {
        return $this->useFullyQualifiedCallingPartyNumber;
    }
    /**
     * Set useFullyQualifiedCallingPartyNumber value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useFullyQualifiedCallingPartyNumber
     * @return \StructType\LRouteListMember
     */
    public function setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useFullyQualifiedCallingPartyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useFullyQualifiedCallingPartyNumber) ? implode(', ', $useFullyQualifiedCallingPartyNumber) : var_export($useFullyQualifiedCallingPartyNumber, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useFullyQualifiedCallingPartyNumber = $useFullyQualifiedCallingPartyNumber;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \StructType\LRouteListMember
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XNumberingPlan', is_array($callingPartyNumberingPlan) ? implode(', ', $callingPartyNumberingPlan) : var_export($callingPartyNumberingPlan, true), implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \StructType\LRouteListMember
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPriOfNumber', is_array($callingPartyNumberType) ? implode(', ', $callingPartyNumberType) : var_export($callingPartyNumberType, true), implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \StructType\LRouteListMember
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XNumberingPlan', is_array($calledPartyNumberingPlan) ? implode(', ', $calledPartyNumberingPlan) : var_export($calledPartyNumberingPlan, true), implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \StructType\LRouteListMember
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPriOfNumber', is_array($calledPartyNumberType) ? implode(', ', $calledPartyNumberType) : var_export($calledPartyNumberType, true), implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LRouteListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
