<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRegionMatrix StructType
 * @subpackage Structs
 */
class LRegionMatrix extends AbstractStructBase
{
    /**
     * The bandwidth
     * Meta information extracted from the WSDL
     * - documentation: The new bandwidth value for this particular region relationship.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoBandwidth;
    /**
     * The regionAName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $regionAName;
    /**
     * The regionBName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $regionBName;
    /**
     * The codecPreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $codecPreference;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRegionMatrix
     * @uses LRegionMatrix::setBandwidth()
     * @uses LRegionMatrix::setVideoBandwidth()
     * @uses LRegionMatrix::setRegionAName()
     * @uses LRegionMatrix::setRegionBName()
     * @uses LRegionMatrix::setCodecPreference()
     * @uses LRegionMatrix::setUuid()
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param \StructType\XFkType $regionAName
     * @param \StructType\XFkType $regionBName
     * @param \StructType\XFkType $codecPreference
     * @param string $uuid
     */
    public function __construct($bandwidth = null, $videoBandwidth = null, \StructType\XFkType $regionAName = null, \StructType\XFkType $regionBName = null, \StructType\XFkType $codecPreference = null, $uuid = null)
    {
        $this
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setRegionAName($regionAName)
            ->setRegionBName($regionBName)
            ->setCodecPreference($codecPreference)
            ->setUuid($uuid);
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @param string $bandwidth
     * @return \StructType\LRegionMatrix
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth) && !is_string($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \StructType\LRegionMatrix
     */
    public function setVideoBandwidth($videoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($videoBandwidth) ? implode(', ', $videoBandwidth) : var_export($videoBandwidth, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get regionAName value
     * @return \StructType\XFkType|null
     */
    public function getRegionAName()
    {
        return $this->regionAName;
    }
    /**
     * Set regionAName value
     * @param \StructType\XFkType $regionAName
     * @return \StructType\LRegionMatrix
     */
    public function setRegionAName(\StructType\XFkType $regionAName = null)
    {
        $this->regionAName = $regionAName;
        return $this;
    }
    /**
     * Get regionBName value
     * @return \StructType\XFkType|null
     */
    public function getRegionBName()
    {
        return $this->regionBName;
    }
    /**
     * Set regionBName value
     * @param \StructType\XFkType $regionBName
     * @return \StructType\LRegionMatrix
     */
    public function setRegionBName(\StructType\XFkType $regionBName = null)
    {
        $this->regionBName = $regionBName;
        return $this;
    }
    /**
     * Get codecPreference value
     * @return \StructType\XFkType|null
     */
    public function getCodecPreference()
    {
        return $this->codecPreference;
    }
    /**
     * Set codecPreference value
     * @param \StructType\XFkType $codecPreference
     * @return \StructType\LRegionMatrix
     */
    public function setCodecPreference(\StructType\XFkType $codecPreference = null)
    {
        $this->codecPreference = $codecPreference;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LRegionMatrix
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
