<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPolicyRelationship StructType
 * @subpackage Structs
 */
class LPolicyRelationship extends AbstractStructBase
{
    /**
     * The geoLocationPolicyAName
     * Meta information extracted from the WSDL
     * - documentation: This is a read only tag. The value will be the currently added GeoLocationPolicy pkid.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationPolicyAName;
    /**
     * The geoLocationDeviceA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geoLocationDeviceA;
    /**
     * The geoLocationPolicyBName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationPolicyBName;
    /**
     * The geoLocationDeviceB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geoLocationDeviceB;
    /**
     * The logicalPartitionPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $logicalPartitionPolicy;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LPolicyRelationship
     * @uses LPolicyRelationship::setGeoLocationPolicyAName()
     * @uses LPolicyRelationship::setGeoLocationDeviceA()
     * @uses LPolicyRelationship::setGeoLocationPolicyBName()
     * @uses LPolicyRelationship::setGeoLocationDeviceB()
     * @uses LPolicyRelationship::setLogicalPartitionPolicy()
     * @uses LPolicyRelationship::setUuid()
     * @param \StructType\XFkType $geoLocationPolicyAName
     * @param string $geoLocationDeviceA
     * @param \StructType\XFkType $geoLocationPolicyBName
     * @param string $geoLocationDeviceB
     * @param string $logicalPartitionPolicy
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $geoLocationPolicyAName = null, $geoLocationDeviceA = null, \StructType\XFkType $geoLocationPolicyBName = null, $geoLocationDeviceB = null, $logicalPartitionPolicy = null, $uuid = null)
    {
        $this
            ->setGeoLocationPolicyAName($geoLocationPolicyAName)
            ->setGeoLocationDeviceA($geoLocationDeviceA)
            ->setGeoLocationPolicyBName($geoLocationPolicyBName)
            ->setGeoLocationDeviceB($geoLocationDeviceB)
            ->setLogicalPartitionPolicy($logicalPartitionPolicy)
            ->setUuid($uuid);
    }
    /**
     * Get geoLocationPolicyAName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationPolicyAName()
    {
        return $this->geoLocationPolicyAName;
    }
    /**
     * Set geoLocationPolicyAName value
     * @param \StructType\XFkType $geoLocationPolicyAName
     * @return \StructType\LPolicyRelationship
     */
    public function setGeoLocationPolicyAName(\StructType\XFkType $geoLocationPolicyAName = null)
    {
        $this->geoLocationPolicyAName = $geoLocationPolicyAName;
        return $this;
    }
    /**
     * Get geoLocationDeviceA value
     * @return string|null
     */
    public function getGeoLocationDeviceA()
    {
        return $this->geoLocationDeviceA;
    }
    /**
     * Set geoLocationDeviceA value
     * @uses \EnumType\XGeoLocationDevice::valueIsValid()
     * @uses \EnumType\XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceA
     * @return \StructType\LPolicyRelationship
     */
    public function setGeoLocationDeviceA($geoLocationDeviceA = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGeoLocationDevice::valueIsValid($geoLocationDeviceA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XGeoLocationDevice', is_array($geoLocationDeviceA) ? implode(', ', $geoLocationDeviceA) : var_export($geoLocationDeviceA, true), implode(', ', \EnumType\XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceA = $geoLocationDeviceA;
        return $this;
    }
    /**
     * Get geoLocationPolicyBName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationPolicyBName()
    {
        return $this->geoLocationPolicyBName;
    }
    /**
     * Set geoLocationPolicyBName value
     * @param \StructType\XFkType $geoLocationPolicyBName
     * @return \StructType\LPolicyRelationship
     */
    public function setGeoLocationPolicyBName(\StructType\XFkType $geoLocationPolicyBName = null)
    {
        $this->geoLocationPolicyBName = $geoLocationPolicyBName;
        return $this;
    }
    /**
     * Get geoLocationDeviceB value
     * @return string|null
     */
    public function getGeoLocationDeviceB()
    {
        return $this->geoLocationDeviceB;
    }
    /**
     * Set geoLocationDeviceB value
     * @uses \EnumType\XGeoLocationDevice::valueIsValid()
     * @uses \EnumType\XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceB
     * @return \StructType\LPolicyRelationship
     */
    public function setGeoLocationDeviceB($geoLocationDeviceB = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGeoLocationDevice::valueIsValid($geoLocationDeviceB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XGeoLocationDevice', is_array($geoLocationDeviceB) ? implode(', ', $geoLocationDeviceB) : var_export($geoLocationDeviceB, true), implode(', ', \EnumType\XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceB = $geoLocationDeviceB;
        return $this;
    }
    /**
     * Get logicalPartitionPolicy value
     * @return string|null
     */
    public function getLogicalPartitionPolicy()
    {
        return $this->logicalPartitionPolicy;
    }
    /**
     * Set logicalPartitionPolicy value
     * @uses \EnumType\XLogicalPartitionPolicy::valueIsValid()
     * @uses \EnumType\XLogicalPartitionPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicalPartitionPolicy
     * @return \StructType\LPolicyRelationship
     */
    public function setLogicalPartitionPolicy($logicalPartitionPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XLogicalPartitionPolicy::valueIsValid($logicalPartitionPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XLogicalPartitionPolicy', is_array($logicalPartitionPolicy) ? implode(', ', $logicalPartitionPolicy) : var_export($logicalPartitionPolicy, true), implode(', ', \EnumType\XLogicalPartitionPolicy::getValidValues())), __LINE__);
        }
        $this->logicalPartitionPolicy = $logicalPartitionPolicy;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LPolicyRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
