<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LMediaResourceGroupMember StructType
 * @subpackage Structs
 */
class LMediaResourceGroupMember extends AbstractStructBase
{
    /**
     * The deviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $deviceName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LMediaResourceGroupMember
     * @uses LMediaResourceGroupMember::setDeviceName()
     * @uses LMediaResourceGroupMember::setUuid()
     * @param \StructType\XFkType $deviceName
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $deviceName = null, $uuid = null)
    {
        $this
            ->setDeviceName($deviceName)
            ->setUuid($uuid);
    }
    /**
     * Get deviceName value
     * @return \StructType\XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \StructType\XFkType $deviceName
     * @return \StructType\LMediaResourceGroupMember
     */
    public function setDeviceName(\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LMediaResourceGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
