<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLineGroup StructType
 * @subpackage Structs
 */
class LLineGroup extends AbstractStructBase
{
    /**
     * The distributionAlgorithm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The rnaReversionTimeOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rnaReversionTimeOut;
    /**
     * The huntAlgorithmNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $huntAlgorithmNoAnswer;
    /**
     * The huntAlgorithmBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $huntAlgorithmBusy;
    /**
     * The huntAlgorithmNotAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $huntAlgorithmNotAvailable;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The autoLogOffHunt
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoLogOffHunt;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLineGroup
     * @uses LLineGroup::setDistributionAlgorithm()
     * @uses LLineGroup::setRnaReversionTimeOut()
     * @uses LLineGroup::setHuntAlgorithmNoAnswer()
     * @uses LLineGroup::setHuntAlgorithmBusy()
     * @uses LLineGroup::setHuntAlgorithmNotAvailable()
     * @uses LLineGroup::setName()
     * @uses LLineGroup::setAutoLogOffHunt()
     * @uses LLineGroup::setUuid()
     * @param string $distributionAlgorithm
     * @param string $rnaReversionTimeOut
     * @param string $huntAlgorithmNoAnswer
     * @param string $huntAlgorithmBusy
     * @param string $huntAlgorithmNotAvailable
     * @param string $name
     * @param string $autoLogOffHunt
     * @param string $uuid
     */
    public function __construct($distributionAlgorithm = null, $rnaReversionTimeOut = null, $huntAlgorithmNoAnswer = null, $huntAlgorithmBusy = null, $huntAlgorithmNotAvailable = null, $name = null, $autoLogOffHunt = null, $uuid = null)
    {
        $this
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setRnaReversionTimeOut($rnaReversionTimeOut)
            ->setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer)
            ->setHuntAlgorithmBusy($huntAlgorithmBusy)
            ->setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable)
            ->setName($name)
            ->setAutoLogOffHunt($autoLogOffHunt)
            ->setUuid($uuid);
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \StructType\LLineGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDistributeAlgorithm', is_array($distributionAlgorithm) ? implode(', ', $distributionAlgorithm) : var_export($distributionAlgorithm, true), implode(', ', \EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get rnaReversionTimeOut value
     * @return string|null
     */
    public function getRnaReversionTimeOut()
    {
        return $this->rnaReversionTimeOut;
    }
    /**
     * Set rnaReversionTimeOut value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rnaReversionTimeOut
     * @return \StructType\LLineGroup
     */
    public function setRnaReversionTimeOut($rnaReversionTimeOut = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($rnaReversionTimeOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($rnaReversionTimeOut) ? implode(', ', $rnaReversionTimeOut) : var_export($rnaReversionTimeOut, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rnaReversionTimeOut = $rnaReversionTimeOut;
        return $this;
    }
    /**
     * Get huntAlgorithmNoAnswer value
     * @return string|null
     */
    public function getHuntAlgorithmNoAnswer()
    {
        return $this->huntAlgorithmNoAnswer;
    }
    /**
     * Set huntAlgorithmNoAnswer value
     * @uses \EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNoAnswer
     * @return \StructType\LLineGroup
     */
    public function setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XHuntAlgorithm', is_array($huntAlgorithmNoAnswer) ? implode(', ', $huntAlgorithmNoAnswer) : var_export($huntAlgorithmNoAnswer, true), implode(', ', \EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNoAnswer = $huntAlgorithmNoAnswer;
        return $this;
    }
    /**
     * Get huntAlgorithmBusy value
     * @return string|null
     */
    public function getHuntAlgorithmBusy()
    {
        return $this->huntAlgorithmBusy;
    }
    /**
     * Set huntAlgorithmBusy value
     * @uses \EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmBusy
     * @return \StructType\LLineGroup
     */
    public function setHuntAlgorithmBusy($huntAlgorithmBusy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmBusy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XHuntAlgorithm', is_array($huntAlgorithmBusy) ? implode(', ', $huntAlgorithmBusy) : var_export($huntAlgorithmBusy, true), implode(', ', \EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmBusy = $huntAlgorithmBusy;
        return $this;
    }
    /**
     * Get huntAlgorithmNotAvailable value
     * @return string|null
     */
    public function getHuntAlgorithmNotAvailable()
    {
        return $this->huntAlgorithmNotAvailable;
    }
    /**
     * Set huntAlgorithmNotAvailable value
     * @uses \EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNotAvailable
     * @return \StructType\LLineGroup
     */
    public function setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNotAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XHuntAlgorithm', is_array($huntAlgorithmNotAvailable) ? implode(', ', $huntAlgorithmNotAvailable) : var_export($huntAlgorithmNotAvailable, true), implode(', ', \EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNotAvailable = $huntAlgorithmNotAvailable;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LLineGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get autoLogOffHunt value
     * @return string|null
     */
    public function getAutoLogOffHunt()
    {
        return $this->autoLogOffHunt;
    }
    /**
     * Set autoLogOffHunt value
     * @param string $autoLogOffHunt
     * @return \StructType\LLineGroup
     */
    public function setAutoLogOffHunt($autoLogOffHunt = null)
    {
        // validation for constraint: string
        if (!is_null($autoLogOffHunt) && !is_string($autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoLogOffHunt, true), gettype($autoLogOffHunt)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($autoLogOffHunt) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($autoLogOffHunt, true)), __LINE__);
        }
        $this->autoLogOffHunt = $autoLogOffHunt;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LLineGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
