<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LImportedDirectoryUriCatalogs StructType
 * @subpackage Structs
 */
class LImportedDirectoryUriCatalogs extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The routeString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeString;
    /**
     * The lastLoadedFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastLoadedFileName;
    /**
     * The fileLoadDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileLoadDateTime;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LImportedDirectoryUriCatalogs
     * @uses LImportedDirectoryUriCatalogs::setName()
     * @uses LImportedDirectoryUriCatalogs::setDescription()
     * @uses LImportedDirectoryUriCatalogs::setRouteString()
     * @uses LImportedDirectoryUriCatalogs::setLastLoadedFileName()
     * @uses LImportedDirectoryUriCatalogs::setFileLoadDateTime()
     * @uses LImportedDirectoryUriCatalogs::setUuid()
     * @param string $name
     * @param string $description
     * @param string $routeString
     * @param string $lastLoadedFileName
     * @param string $fileLoadDateTime
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $routeString = null, $lastLoadedFileName = null, $fileLoadDateTime = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setRouteString($routeString)
            ->setLastLoadedFileName($lastLoadedFileName)
            ->setFileLoadDateTime($fileLoadDateTime)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LImportedDirectoryUriCatalogs
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LImportedDirectoryUriCatalogs
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get routeString value
     * @return string|null
     */
    public function getRouteString()
    {
        return $this->routeString;
    }
    /**
     * Set routeString value
     * @param string $routeString
     * @return \StructType\LImportedDirectoryUriCatalogs
     */
    public function setRouteString($routeString = null)
    {
        // validation for constraint: string
        if (!is_null($routeString) && !is_string($routeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeString, true), gettype($routeString)), __LINE__);
        }
        $this->routeString = $routeString;
        return $this;
    }
    /**
     * Get lastLoadedFileName value
     * @return string|null
     */
    public function getLastLoadedFileName()
    {
        return $this->lastLoadedFileName;
    }
    /**
     * Set lastLoadedFileName value
     * @param string $lastLoadedFileName
     * @return \StructType\LImportedDirectoryUriCatalogs
     */
    public function setLastLoadedFileName($lastLoadedFileName = null)
    {
        // validation for constraint: string
        if (!is_null($lastLoadedFileName) && !is_string($lastLoadedFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastLoadedFileName, true), gettype($lastLoadedFileName)), __LINE__);
        }
        $this->lastLoadedFileName = $lastLoadedFileName;
        return $this;
    }
    /**
     * Get fileLoadDateTime value
     * @return string|null
     */
    public function getFileLoadDateTime()
    {
        return $this->fileLoadDateTime;
    }
    /**
     * Set fileLoadDateTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileLoadDateTime
     * @return \StructType\LImportedDirectoryUriCatalogs
     */
    public function setFileLoadDateTime($fileLoadDateTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($fileLoadDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($fileLoadDateTime) ? implode(', ', $fileLoadDateTime) : var_export($fileLoadDateTime, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->fileLoadDateTime = $fileLoadDateTime;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LImportedDirectoryUriCatalogs
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
