<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LImeExclusionNumber StructType
 * @subpackage Structs
 */
class LImeExclusionNumber extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The imeExclusionNumberGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $imeExclusionNumberGroupName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LImeExclusionNumber
     * @uses LImeExclusionNumber::setPattern()
     * @uses LImeExclusionNumber::setDescription()
     * @uses LImeExclusionNumber::setImeExclusionNumberGroupName()
     * @uses LImeExclusionNumber::setUuid()
     * @param string $pattern
     * @param string $description
     * @param \StructType\XFkType $imeExclusionNumberGroupName
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, \StructType\XFkType $imeExclusionNumberGroupName = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setImeExclusionNumberGroupName($imeExclusionNumberGroupName)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\LImeExclusionNumber
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pattern) && mb_strlen($pattern) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LImeExclusionNumber
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get imeExclusionNumberGroupName value
     * @return \StructType\XFkType|null
     */
    public function getImeExclusionNumberGroupName()
    {
        return $this->imeExclusionNumberGroupName;
    }
    /**
     * Set imeExclusionNumberGroupName value
     * @param \StructType\XFkType $imeExclusionNumberGroupName
     * @return \StructType\LImeExclusionNumber
     */
    public function setImeExclusionNumberGroupName(\StructType\XFkType $imeExclusionNumberGroupName = null)
    {
        $this->imeExclusionNumberGroupName = $imeExclusionNumberGroupName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LImeExclusionNumber
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
