<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LImeClientMember StructType
 * @subpackage Structs
 */
class LImeClientMember extends AbstractStructBase
{
    /**
     * The enrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $enrolledPatternGroupName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LImeClientMember
     * @uses LImeClientMember::setEnrolledPatternGroupName()
     * @uses LImeClientMember::setUuid()
     * @param \StructType\XFkType $enrolledPatternGroupName
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $enrolledPatternGroupName = null, $uuid = null)
    {
        $this
            ->setEnrolledPatternGroupName($enrolledPatternGroupName)
            ->setUuid($uuid);
    }
    /**
     * Get enrolledPatternGroupName value
     * @return \StructType\XFkType|null
     */
    public function getEnrolledPatternGroupName()
    {
        return $this->enrolledPatternGroupName;
    }
    /**
     * Set enrolledPatternGroupName value
     * @param \StructType\XFkType $enrolledPatternGroupName
     * @return \StructType\LImeClientMember
     */
    public function setEnrolledPatternGroupName(\StructType\XFkType $enrolledPatternGroupName = null)
    {
        $this->enrolledPatternGroupName = $enrolledPatternGroupName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LImeClientMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
