<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LHuntListMember StructType
 * @subpackage Structs
 */
class LHuntListMember extends AbstractStructBase
{
    /**
     * The lineGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $lineGroupName;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LHuntListMember
     * @uses LHuntListMember::setLineGroupName()
     * @uses LHuntListMember::setSelectionOrder()
     * @uses LHuntListMember::setUuid()
     * @param \StructType\XFkType $lineGroupName
     * @param string $selectionOrder
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $lineGroupName = null, $selectionOrder = null, $uuid = null)
    {
        $this
            ->setLineGroupName($lineGroupName)
            ->setSelectionOrder($selectionOrder)
            ->setUuid($uuid);
    }
    /**
     * Get lineGroupName value
     * @return \StructType\XFkType|null
     */
    public function getLineGroupName()
    {
        return $this->lineGroupName;
    }
    /**
     * Set lineGroupName value
     * @param \StructType\XFkType $lineGroupName
     * @return \StructType\LHuntListMember
     */
    public function setLineGroupName(\StructType\XFkType $lineGroupName = null)
    {
        $this->lineGroupName = $lineGroupName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\LHuntListMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LHuntListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
