<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LH323Line StructType
 * @subpackage Structs
 */
class LH323Line extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiLabel;
    /**
     * The display
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $display;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LDirn
     */
    public $dirn;
    /**
     * The displayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164Mask;
    /**
     * The dialPlanWizardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardId;
    /**
     * The maxNumCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LH323Line
     * @uses LH323Line::setIndex()
     * @uses LH323Line::setLabel()
     * @uses LH323Line::setAsciiLabel()
     * @uses LH323Line::setDisplay()
     * @uses LH323Line::setDirn()
     * @uses LH323Line::setDisplayAscii()
     * @uses LH323Line::setE164Mask()
     * @uses LH323Line::setDialPlanWizardId()
     * @uses LH323Line::setMaxNumCalls()
     * @uses LH323Line::setBusyTrigger()
     * @uses LH323Line::setCallInfoDisplay()
     * @uses LH323Line::setRecordingProfileName()
     * @uses LH323Line::setMonitoringCssName()
     * @uses LH323Line::setRecordingFlag()
     * @uses LH323Line::setAudibleMwi()
     * @uses LH323Line::setSpeedDial()
     * @uses LH323Line::setPartitionUsage()
     * @uses LH323Line::setAssociatedEndusers()
     * @uses LH323Line::setCtiid()
     * @uses LH323Line::setUuid()
     * @param string $index
     * @param string $label
     * @param string $asciiLabel
     * @param string $display
     * @param \StructType\LDirn $dirn
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $dialPlanWizardId
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \StructType\CallInfoDisplay $callInfoDisplay
     * @param \StructType\XFkType $recordingProfileName
     * @param \StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param \StructType\AssociatedEndusers $associatedEndusers
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $label = null, $asciiLabel = null, $display = null, \StructType\LDirn $dirn = null, $displayAscii = null, $e164Mask = null, $dialPlanWizardId = null, $maxNumCalls = null, $busyTrigger = null, \StructType\CallInfoDisplay $callInfoDisplay = null, \StructType\XFkType $recordingProfileName = null, \StructType\XFkType $monitoringCssName = null, $recordingFlag = null, $audibleMwi = null, $speedDial = null, $partitionUsage = null, \StructType\AssociatedEndusers $associatedEndusers = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setDisplay($display)
            ->setDirn($dirn)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setDialPlanWizardId($dialPlanWizardId)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\LH323Line
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\LH323Line
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($label) && mb_strlen($label) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \StructType\LH323Line
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        // validation for constraint: string
        if (!is_null($asciiLabel) && !is_string($asciiLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiLabel, true), gettype($asciiLabel)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($asciiLabel) && mb_strlen($asciiLabel) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($asciiLabel)), __LINE__);
        }
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \StructType\LH323Line
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($display) && mb_strlen($display) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get dirn value
     * @return \StructType\LDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \StructType\LDirn $dirn
     * @return \StructType\LH323Line
     */
    public function setDirn(\StructType\LDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \StructType\LH323Line
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayAscii, true), gettype($displayAscii)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($displayAscii) && mb_strlen($displayAscii) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \StructType\LH323Line
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e164Mask, true), gettype($e164Mask)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($e164Mask) && mb_strlen($e164Mask) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get dialPlanWizardId value
     * @return string|null
     */
    public function getDialPlanWizardId()
    {
        return $this->dialPlanWizardId;
    }
    /**
     * Set dialPlanWizardId value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardId
     * @return \StructType\LH323Line
     */
    public function setDialPlanWizardId($dialPlanWizardId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dialPlanWizardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dialPlanWizardId) ? implode(', ', $dialPlanWizardId) : var_export($dialPlanWizardId, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardId = $dialPlanWizardId;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return \StructType\LH323Line
     */
    public function setMaxNumCalls($maxNumCalls = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($maxNumCalls) ? implode(', ', $maxNumCalls) : var_export($maxNumCalls, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \StructType\LH323Line
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($busyTrigger) ? implode(', ', $busyTrigger) : var_export($busyTrigger, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \StructType\CallInfoDisplay $callInfoDisplay
     * @return \StructType\LH323Line
     */
    public function setCallInfoDisplay(\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return \StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param \StructType\XFkType $recordingProfileName
     * @return \StructType\LH323Line
     */
    public function setRecordingProfileName(\StructType\XFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return \StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param \StructType\XFkType $monitoringCssName
     * @return \StructType\LH323Line
     */
    public function setMonitoringCssName(\StructType\XFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses \EnumType\XRecordingFlag::valueIsValid()
     * @uses \EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return \StructType\LH323Line
     */
    public function setRecordingFlag($recordingFlag = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRecordingFlag', is_array($recordingFlag) ? implode(', ', $recordingFlag) : var_export($recordingFlag, true), implode(', ', \EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return \StructType\LH323Line
     */
    public function setAudibleMwi($audibleMwi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($audibleMwi) ? implode(', ', $audibleMwi) : var_export($audibleMwi, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * @return string|null
     */
    public function getSpeedDial()
    {
        return $this->speedDial;
    }
    /**
     * Set speedDial value
     * @param string $speedDial
     * @return \StructType\LH323Line
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($speedDial, true), gettype($speedDial)), __LINE__);
        }
        $this->speedDial = $speedDial;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \EnumType\XPartitionUsage::valueIsValid()
     * @uses \EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \StructType\LH323Line
     */
    public function setPartitionUsage($partitionUsage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPartitionUsage', is_array($partitionUsage) ? implode(', ', $partitionUsage) : var_export($partitionUsage, true), implode(', ', \EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \StructType\AssociatedEndusers $associatedEndusers
     * @return \StructType\LH323Line
     */
    public function setAssociatedEndusers(\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\LH323Line
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LH323Line
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
