<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDialPlanTag StructType
 * @subpackage Structs
 */
class LDialPlanTag extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Actually called "tag" in database.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The operator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The suppressFromRouteFilter
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $suppressFromRouteFilter;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDialPlanTag
     * @uses LDialPlanTag::setName()
     * @uses LDialPlanTag::setDialPlanName()
     * @uses LDialPlanTag::setOperator()
     * @uses LDialPlanTag::setSuppressFromRouteFilter()
     * @uses LDialPlanTag::setUuid()
     * @param string $name
     * @param \StructType\XFkType $dialPlanName
     * @param string $operator
     * @param string $suppressFromRouteFilter
     * @param string $uuid
     */
    public function __construct($name = null, \StructType\XFkType $dialPlanName = null, $operator = null, $suppressFromRouteFilter = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDialPlanName($dialPlanName)
            ->setOperator($operator)
            ->setSuppressFromRouteFilter($suppressFromRouteFilter)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LDialPlanTag
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \StructType\XFkType $dialPlanName
     * @return \StructType\LDialPlanTag
     */
    public function setDialPlanName(\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\XOperator::valueIsValid()
     * @uses \EnumType\XOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\LDialPlanTag
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\XOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get suppressFromRouteFilter value
     * @return string|null
     */
    public function getSuppressFromRouteFilter()
    {
        return $this->suppressFromRouteFilter;
    }
    /**
     * Set suppressFromRouteFilter value
     * @param string $suppressFromRouteFilter
     * @return \StructType\LDialPlanTag
     */
    public function setSuppressFromRouteFilter($suppressFromRouteFilter = null)
    {
        // validation for constraint: string
        if (!is_null($suppressFromRouteFilter) && !is_string($suppressFromRouteFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suppressFromRouteFilter, true), gettype($suppressFromRouteFilter)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($suppressFromRouteFilter) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $suppressFromRouteFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($suppressFromRouteFilter, true)), __LINE__);
        }
        $this->suppressFromRouteFilter = $suppressFromRouteFilter;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LDialPlanTag
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
