<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCumaServerSecurityProfile StructType
 * @subpackage Structs
 */
class LCumaServerSecurityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $securityMode;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportType;
    /**
     * The x509SubjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $x509SubjectName;
    /**
     * The serverIpHostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serverIpHostName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCumaServerSecurityProfile
     * @uses LCumaServerSecurityProfile::setName()
     * @uses LCumaServerSecurityProfile::setDescription()
     * @uses LCumaServerSecurityProfile::setSecurityMode()
     * @uses LCumaServerSecurityProfile::setTransportType()
     * @uses LCumaServerSecurityProfile::setX509SubjectName()
     * @uses LCumaServerSecurityProfile::setServerIpHostName()
     * @uses LCumaServerSecurityProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $securityMode
     * @param string $transportType
     * @param string $x509SubjectName
     * @param string $serverIpHostName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $securityMode = null, $transportType = null, $x509SubjectName = null, $serverIpHostName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setTransportType($transportType)
            ->setX509SubjectName($x509SubjectName)
            ->setServerIpHostName($serverIpHostName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LCumaServerSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LCumaServerSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get securityMode value
     * @return string|null
     */
    public function getSecurityMode()
    {
        return $this->securityMode;
    }
    /**
     * Set securityMode value
     * @uses \EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return \StructType\LCumaServerSecurityProfile
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDeviceSecurityMode', is_array($securityMode) ? implode(', ', $securityMode) : var_export($securityMode, true), implode(', ', \EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        $this->securityMode = $securityMode;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses \EnumType\XTransport::valueIsValid()
     * @uses \EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return \StructType\LCumaServerSecurityProfile
     */
    public function setTransportType($transportType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTransport', is_array($transportType) ? implode(', ', $transportType) : var_export($transportType, true), implode(', ', \EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \StructType\LCumaServerSecurityProfile
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509SubjectName, true), gettype($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get serverIpHostName value
     * @return string|null
     */
    public function getServerIpHostName()
    {
        return $this->serverIpHostName;
    }
    /**
     * Set serverIpHostName value
     * @param string $serverIpHostName
     * @return \StructType\LCumaServerSecurityProfile
     */
    public function setServerIpHostName($serverIpHostName = null)
    {
        // validation for constraint: string
        if (!is_null($serverIpHostName) && !is_string($serverIpHostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverIpHostName, true), gettype($serverIpHostName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($serverIpHostName) && mb_strlen($serverIpHostName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($serverIpHostName)), __LINE__);
        }
        $this->serverIpHostName = $serverIpHostName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LCumaServerSecurityProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
