<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCredentialPolicyDefault StructType
 * @subpackage Structs
 */
class LCredentialPolicyDefault extends AbstractStructBase
{
    /**
     * The credentialUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credentialUser;
    /**
     * The credentialType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credentialType;
    /**
     * The credPolicyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $credPolicyName;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credentials;
    /**
     * The confirmCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $confirmCredentials;
    /**
     * The credUserCantChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserCantChange;
    /**
     * The credUserMustChange
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserMustChange;
    /**
     * The credDoesNotExpire
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credDoesNotExpire;
    /**
     * Constructor method for LCredentialPolicyDefault
     * @uses LCredentialPolicyDefault::setCredentialUser()
     * @uses LCredentialPolicyDefault::setCredentialType()
     * @uses LCredentialPolicyDefault::setCredPolicyName()
     * @uses LCredentialPolicyDefault::setCredentials()
     * @uses LCredentialPolicyDefault::setConfirmCredentials()
     * @uses LCredentialPolicyDefault::setCredUserCantChange()
     * @uses LCredentialPolicyDefault::setCredUserMustChange()
     * @uses LCredentialPolicyDefault::setCredDoesNotExpire()
     * @param string $credentialUser
     * @param string $credentialType
     * @param \StructType\XFkType $credPolicyName
     * @param string $credentials
     * @param string $confirmCredentials
     * @param string $credUserCantChange
     * @param string $credUserMustChange
     * @param string $credDoesNotExpire
     */
    public function __construct($credentialUser = null, $credentialType = null, \StructType\XFkType $credPolicyName = null, $credentials = null, $confirmCredentials = null, $credUserCantChange = null, $credUserMustChange = null, $credDoesNotExpire = null)
    {
        $this
            ->setCredentialUser($credentialUser)
            ->setCredentialType($credentialType)
            ->setCredPolicyName($credPolicyName)
            ->setCredentials($credentials)
            ->setConfirmCredentials($confirmCredentials)
            ->setCredUserCantChange($credUserCantChange)
            ->setCredUserMustChange($credUserMustChange)
            ->setCredDoesNotExpire($credDoesNotExpire);
    }
    /**
     * Get credentialUser value
     * @return string|null
     */
    public function getCredentialUser()
    {
        return $this->credentialUser;
    }
    /**
     * Set credentialUser value
     * @uses \EnumType\XCredentialUser::valueIsValid()
     * @uses \EnumType\XCredentialUser::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialUser
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setCredentialUser($credentialUser = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCredentialUser::valueIsValid($credentialUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCredentialUser', is_array($credentialUser) ? implode(', ', $credentialUser) : var_export($credentialUser, true), implode(', ', \EnumType\XCredentialUser::getValidValues())), __LINE__);
        }
        $this->credentialUser = $credentialUser;
        return $this;
    }
    /**
     * Get credentialType value
     * @return string|null
     */
    public function getCredentialType()
    {
        return $this->credentialType;
    }
    /**
     * Set credentialType value
     * @uses \EnumType\XCredential::valueIsValid()
     * @uses \EnumType\XCredential::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialType
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setCredentialType($credentialType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCredential::valueIsValid($credentialType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCredential', is_array($credentialType) ? implode(', ', $credentialType) : var_export($credentialType, true), implode(', ', \EnumType\XCredential::getValidValues())), __LINE__);
        }
        $this->credentialType = $credentialType;
        return $this;
    }
    /**
     * Get credPolicyName value
     * @return \StructType\XFkType|null
     */
    public function getCredPolicyName()
    {
        return $this->credPolicyName;
    }
    /**
     * Set credPolicyName value
     * @param \StructType\XFkType $credPolicyName
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setCredPolicyName(\StructType\XFkType $credPolicyName = null)
    {
        $this->credPolicyName = $credPolicyName;
        return $this;
    }
    /**
     * Get credentials value
     * @return string|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param string $credentials
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setCredentials($credentials = null)
    {
        // validation for constraint: string
        if (!is_null($credentials) && !is_string($credentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credentials, true), gettype($credentials)), __LINE__);
        }
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get confirmCredentials value
     * @return string|null
     */
    public function getConfirmCredentials()
    {
        return $this->confirmCredentials;
    }
    /**
     * Set confirmCredentials value
     * @param string $confirmCredentials
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setConfirmCredentials($confirmCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($confirmCredentials) && !is_string($confirmCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmCredentials, true), gettype($confirmCredentials)), __LINE__);
        }
        $this->confirmCredentials = $confirmCredentials;
        return $this;
    }
    /**
     * Get credUserCantChange value
     * @return string|null
     */
    public function getCredUserCantChange()
    {
        return $this->credUserCantChange;
    }
    /**
     * Set credUserCantChange value
     * @param string $credUserCantChange
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setCredUserCantChange($credUserCantChange = null)
    {
        // validation for constraint: string
        if (!is_null($credUserCantChange) && !is_string($credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credUserCantChange, true), gettype($credUserCantChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credUserCantChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credUserCantChange, true)), __LINE__);
        }
        $this->credUserCantChange = $credUserCantChange;
        return $this;
    }
    /**
     * Get credUserMustChange value
     * @return string|null
     */
    public function getCredUserMustChange()
    {
        return $this->credUserMustChange;
    }
    /**
     * Set credUserMustChange value
     * @param string $credUserMustChange
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setCredUserMustChange($credUserMustChange = null)
    {
        // validation for constraint: string
        if (!is_null($credUserMustChange) && !is_string($credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credUserMustChange, true), gettype($credUserMustChange)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credUserMustChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credUserMustChange, true)), __LINE__);
        }
        $this->credUserMustChange = $credUserMustChange;
        return $this;
    }
    /**
     * Get credDoesNotExpire value
     * @return string|null
     */
    public function getCredDoesNotExpire()
    {
        return $this->credDoesNotExpire;
    }
    /**
     * Set credDoesNotExpire value
     * @param string $credDoesNotExpire
     * @return \StructType\LCredentialPolicyDefault
     */
    public function setCredDoesNotExpire($credDoesNotExpire = null)
    {
        // validation for constraint: string
        if (!is_null($credDoesNotExpire) && !is_string($credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credDoesNotExpire, true), gettype($credDoesNotExpire)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($credDoesNotExpire) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($credDoesNotExpire, true)), __LINE__);
        }
        $this->credDoesNotExpire = $credDoesNotExpire;
        return $this;
    }
}
