<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LConferenceBridge StructType
 * @subpackage Structs
 */
class LConferenceBridge extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:Name
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The subUnit
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values range from 1 to 4.The value should be given as per the formula. Cisco Media Server : subunit = ((Extract two digits after 'A'
     * from the name)-2)/3 + 1. Cisco Conference Bridge: subunit = ((Extract two digits after 'C' from the name)-1)/3 + 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subUnit;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Conference Bridge Hardware.For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the
     * product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The maximumCapacity
     * Meta information extracted from the WSDL
     * - documentation: This tag is mandatory for Cisco Conference Bridge(WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco IOS Enhanced Conference Bridge
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The destinationAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddress;
    /**
     * The mcuConferenceBridgeSipPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mcuConferenceBridgeSipPort;
    /**
     * The sipProfile
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipProfile;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The normalizationScript
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $normalizationScript;
    /**
     * The enableTrace
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTrace;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The httpPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $httpPort;
    /**
     * The useHttps
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHttps;
    /**
     * The conferenceBridgePrefix
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $conferenceBridgePrefix;
    /**
     * The overrideSIPTrunkAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideSIPTrunkAddress;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LConferenceBridge
     * @uses LConferenceBridge::setName()
     * @uses LConferenceBridge::setDescription()
     * @uses LConferenceBridge::setProduct()
     * @uses LConferenceBridge::setDevicePoolName()
     * @uses LConferenceBridge::setCommonDeviceConfigName()
     * @uses LConferenceBridge::setLocationName()
     * @uses LConferenceBridge::setSubUnit()
     * @uses LConferenceBridge::setLoadInformation()
     * @uses LConferenceBridge::setMaximumCapacity()
     * @uses LConferenceBridge::setUseTrustedRelayPoint()
     * @uses LConferenceBridge::setSecurityProfileName()
     * @uses LConferenceBridge::setDestinationAddress()
     * @uses LConferenceBridge::setMcuConferenceBridgeSipPort()
     * @uses LConferenceBridge::setSipProfile()
     * @uses LConferenceBridge::setSrtpAllowed()
     * @uses LConferenceBridge::setNormalizationScript()
     * @uses LConferenceBridge::setEnableTrace()
     * @uses LConferenceBridge::setUserName()
     * @uses LConferenceBridge::setPassword()
     * @uses LConferenceBridge::setHttpPort()
     * @uses LConferenceBridge::setUseHttps()
     * @uses LConferenceBridge::setConferenceBridgePrefix()
     * @uses LConferenceBridge::setOverrideSIPTrunkAddress()
     * @uses LConferenceBridge::setSipTrunkName()
     * @uses LConferenceBridge::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param \StructType\XFkType $locationName
     * @param string $subUnit
     * @param \StructType\XLoadInformation $loadInformation
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param \StructType\XFkType $securityProfileName
     * @param string $destinationAddress
     * @param string $mcuConferenceBridgeSipPort
     * @param \StructType\XFkType $sipProfile
     * @param string $srtpAllowed
     * @param \StructType\XFkType $normalizationScript
     * @param string $enableTrace
     * @param string $userName
     * @param string $password
     * @param string $httpPort
     * @param string $useHttps
     * @param string $conferenceBridgePrefix
     * @param string $overrideSIPTrunkAddress
     * @param \StructType\XFkType $sipTrunkName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, \StructType\XFkType $locationName = null, $subUnit = null, \StructType\XLoadInformation $loadInformation = null, $maximumCapacity = null, $useTrustedRelayPoint = null, \StructType\XFkType $securityProfileName = null, $destinationAddress = null, $mcuConferenceBridgeSipPort = null, \StructType\XFkType $sipProfile = null, $srtpAllowed = null, \StructType\XFkType $normalizationScript = null, $enableTrace = null, $userName = null, $password = null, $httpPort = null, $useHttps = null, $conferenceBridgePrefix = null, $overrideSIPTrunkAddress = null, \StructType\XFkType $sipTrunkName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setSubUnit($subUnit)
            ->setLoadInformation($loadInformation)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setDestinationAddress($destinationAddress)
            ->setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort)
            ->setSipProfile($sipProfile)
            ->setSrtpAllowed($srtpAllowed)
            ->setNormalizationScript($normalizationScript)
            ->setEnableTrace($enableTrace)
            ->setUserName($userName)
            ->setPassword($password)
            ->setHttpPort($httpPort)
            ->setUseHttps($useHttps)
            ->setConferenceBridgePrefix($conferenceBridgePrefix)
            ->setOverrideSIPTrunkAddress($overrideSIPTrunkAddress)
            ->setSipTrunkName($sipTrunkName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LConferenceBridge
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LConferenceBridge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\LConferenceBridge
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\LConferenceBridge
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\LConferenceBridge
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\LConferenceBridge
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subUnit
     * @return \StructType\LConferenceBridge
     */
    public function setSubUnit($subUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($subUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($subUnit) ? implode(', ', $subUnit) : var_export($subUnit, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \StructType\XLoadInformation $loadInformation
     * @return \StructType\LConferenceBridge
     */
    public function setLoadInformation(\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maximumCapacity
     * @return \StructType\LConferenceBridge
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maximumCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($maximumCapacity) ? implode(', ', $maximumCapacity) : var_export($maximumCapacity, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\LConferenceBridge
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \StructType\XFkType $securityProfileName
     * @return \StructType\LConferenceBridge
     */
    public function setSecurityProfileName(\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \StructType\LConferenceBridge
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAddress, true), gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get mcuConferenceBridgeSipPort value
     * @return string|null
     */
    public function getMcuConferenceBridgeSipPort()
    {
        return $this->mcuConferenceBridgeSipPort;
    }
    /**
     * Set mcuConferenceBridgeSipPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mcuConferenceBridgeSipPort
     * @return \StructType\LConferenceBridge
     */
    public function setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($mcuConferenceBridgeSipPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($mcuConferenceBridgeSipPort) ? implode(', ', $mcuConferenceBridgeSipPort) : var_export($mcuConferenceBridgeSipPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mcuConferenceBridgeSipPort = $mcuConferenceBridgeSipPort;
        return $this;
    }
    /**
     * Get sipProfile value
     * @return \StructType\XFkType|null
     */
    public function getSipProfile()
    {
        return $this->sipProfile;
    }
    /**
     * Set sipProfile value
     * @param \StructType\XFkType $sipProfile
     * @return \StructType\LConferenceBridge
     */
    public function setSipProfile(\StructType\XFkType $sipProfile = null)
    {
        $this->sipProfile = $sipProfile;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \StructType\LConferenceBridge
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srtpAllowed, true), gettype($srtpAllowed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($srtpAllowed, true)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get normalizationScript value
     * @return \StructType\XFkType|null
     */
    public function getNormalizationScript()
    {
        return $this->normalizationScript;
    }
    /**
     * Set normalizationScript value
     * @param \StructType\XFkType $normalizationScript
     * @return \StructType\LConferenceBridge
     */
    public function setNormalizationScript(\StructType\XFkType $normalizationScript = null)
    {
        $this->normalizationScript = $normalizationScript;
        return $this;
    }
    /**
     * Get enableTrace value
     * @return string|null
     */
    public function getEnableTrace()
    {
        return $this->enableTrace;
    }
    /**
     * Set enableTrace value
     * @param string $enableTrace
     * @return \StructType\LConferenceBridge
     */
    public function setEnableTrace($enableTrace = null)
    {
        // validation for constraint: string
        if (!is_null($enableTrace) && !is_string($enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableTrace, true), gettype($enableTrace)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableTrace) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableTrace, true)), __LINE__);
        }
        $this->enableTrace = $enableTrace;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\LConferenceBridge
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\LConferenceBridge
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get httpPort value
     * @return string|null
     */
    public function getHttpPort()
    {
        return $this->httpPort;
    }
    /**
     * Set httpPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $httpPort
     * @return \StructType\LConferenceBridge
     */
    public function setHttpPort($httpPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($httpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($httpPort) ? implode(', ', $httpPort) : var_export($httpPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->httpPort = $httpPort;
        return $this;
    }
    /**
     * Get useHttps value
     * @return string|null
     */
    public function getUseHttps()
    {
        return $this->useHttps;
    }
    /**
     * Set useHttps value
     * @param string $useHttps
     * @return \StructType\LConferenceBridge
     */
    public function setUseHttps($useHttps = null)
    {
        // validation for constraint: string
        if (!is_null($useHttps) && !is_string($useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useHttps, true), gettype($useHttps)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useHttps) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useHttps, true)), __LINE__);
        }
        $this->useHttps = $useHttps;
        return $this;
    }
    /**
     * Get conferenceBridgePrefix value
     * @return string|null
     */
    public function getConferenceBridgePrefix()
    {
        return $this->conferenceBridgePrefix;
    }
    /**
     * Set conferenceBridgePrefix value
     * @param string $conferenceBridgePrefix
     * @return \StructType\LConferenceBridge
     */
    public function setConferenceBridgePrefix($conferenceBridgePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceBridgePrefix) && !is_string($conferenceBridgePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conferenceBridgePrefix, true), gettype($conferenceBridgePrefix)), __LINE__);
        }
        $this->conferenceBridgePrefix = $conferenceBridgePrefix;
        return $this;
    }
    /**
     * Get overrideSIPTrunkAddress value
     * @return string|null
     */
    public function getOverrideSIPTrunkAddress()
    {
        return $this->overrideSIPTrunkAddress;
    }
    /**
     * Set overrideSIPTrunkAddress value
     * @param string $overrideSIPTrunkAddress
     * @return \StructType\LConferenceBridge
     */
    public function setOverrideSIPTrunkAddress($overrideSIPTrunkAddress = null)
    {
        // validation for constraint: string
        if (!is_null($overrideSIPTrunkAddress) && !is_string($overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideSIPTrunkAddress, true), gettype($overrideSIPTrunkAddress)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($overrideSIPTrunkAddress) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($overrideSIPTrunkAddress, true)), __LINE__);
        }
        $this->overrideSIPTrunkAddress = $overrideSIPTrunkAddress;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\LConferenceBridge
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LConferenceBridge
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
