<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getNumDevicesResponse StructType
 * @subpackage Structs
 */
class GetNumDevicesResponse extends GetNumDevicesRes
{
    /**
     * The class
     * Meta information extracted from the WSDL
     * - base: xsd:Name
     * - maxLength: 128
     * - use: optional
     * @var string
     */
    public $class;
    /**
     * Constructor method for getNumDevicesResponse
     * @uses GetNumDevicesResponse::setClass()
     * @param string $class
     */
    public function __construct($class = null)
    {
        $this
            ->setClass($class);
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \StructType\GetNumDevicesResponse
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($class) && mb_strlen($class) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($class)), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
}
