<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for e164AltNum StructType
 * Meta information extracted from the WSDL
 * - documentation: Applicable only for Update and Get Request
 * @subpackage Structs
 */
class E164AltNum extends AbstractStructBase
{
    /**
     * The numMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numMask;
    /**
     * The isUrgent
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isUrgent;
    /**
     * The addLocalRoutePartition
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $addLocalRoutePartition;
    /**
     * The routePartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartition;
    /**
     * The advertiseGloballyIls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $advertiseGloballyIls;
    /**
     * The member
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XE164AltNum
     */
    public $member;
    /**
     * Constructor method for e164AltNum
     * @uses E164AltNum::setNumMask()
     * @uses E164AltNum::setIsUrgent()
     * @uses E164AltNum::setAddLocalRoutePartition()
     * @uses E164AltNum::setRoutePartition()
     * @uses E164AltNum::setAdvertiseGloballyIls()
     * @uses E164AltNum::setMember()
     * @param string $numMask
     * @param string $isUrgent
     * @param string $addLocalRoutePartition
     * @param \StructType\XFkType $routePartition
     * @param string $advertiseGloballyIls
     * @param \StructType\XE164AltNum $member
     */
    public function __construct($numMask = null, $isUrgent = 'false', $addLocalRoutePartition = 'true', \StructType\XFkType $routePartition = null, $advertiseGloballyIls = 'true', \StructType\XE164AltNum $member = null)
    {
        $this
            ->setNumMask($numMask)
            ->setIsUrgent($isUrgent)
            ->setAddLocalRoutePartition($addLocalRoutePartition)
            ->setRoutePartition($routePartition)
            ->setAdvertiseGloballyIls($advertiseGloballyIls)
            ->setMember($member);
    }
    /**
     * Get numMask value
     * @return string|null
     */
    public function getNumMask()
    {
        return $this->numMask;
    }
    /**
     * Set numMask value
     * @param string $numMask
     * @return \StructType\E164AltNum
     */
    public function setNumMask($numMask = null)
    {
        // validation for constraint: string
        if (!is_null($numMask) && !is_string($numMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numMask, true), gettype($numMask)), __LINE__);
        }
        $this->numMask = $numMask;
        return $this;
    }
    /**
     * Get isUrgent value
     * @return string|null
     */
    public function getIsUrgent()
    {
        return $this->isUrgent;
    }
    /**
     * Set isUrgent value
     * @param string $isUrgent
     * @return \StructType\E164AltNum
     */
    public function setIsUrgent($isUrgent = 'false')
    {
        // validation for constraint: string
        if (!is_null($isUrgent) && !is_string($isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isUrgent, true), gettype($isUrgent)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isUrgent) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isUrgent, true)), __LINE__);
        }
        $this->isUrgent = $isUrgent;
        return $this;
    }
    /**
     * Get addLocalRoutePartition value
     * @return string|null
     */
    public function getAddLocalRoutePartition()
    {
        return $this->addLocalRoutePartition;
    }
    /**
     * Set addLocalRoutePartition value
     * @param string $addLocalRoutePartition
     * @return \StructType\E164AltNum
     */
    public function setAddLocalRoutePartition($addLocalRoutePartition = 'true')
    {
        // validation for constraint: string
        if (!is_null($addLocalRoutePartition) && !is_string($addLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addLocalRoutePartition, true), gettype($addLocalRoutePartition)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($addLocalRoutePartition) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $addLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($addLocalRoutePartition, true)), __LINE__);
        }
        $this->addLocalRoutePartition = $addLocalRoutePartition;
        return $this;
    }
    /**
     * Get routePartition value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param \StructType\XFkType $routePartition
     * @return \StructType\E164AltNum
     */
    public function setRoutePartition(\StructType\XFkType $routePartition = null)
    {
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get advertiseGloballyIls value
     * @return string|null
     */
    public function getAdvertiseGloballyIls()
    {
        return $this->advertiseGloballyIls;
    }
    /**
     * Set advertiseGloballyIls value
     * @param string $advertiseGloballyIls
     * @return \StructType\E164AltNum
     */
    public function setAdvertiseGloballyIls($advertiseGloballyIls = 'true')
    {
        // validation for constraint: string
        if (!is_null($advertiseGloballyIls) && !is_string($advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertiseGloballyIls, true), gettype($advertiseGloballyIls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($advertiseGloballyIls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($advertiseGloballyIls, true)), __LINE__);
        }
        $this->advertiseGloballyIls = $advertiseGloballyIls;
        return $this;
    }
    /**
     * Get member value
     * @return \StructType\XE164AltNum|null
     */
    public function getMember()
    {
        return $this->member;
    }
    /**
     * Set member value
     * @param \StructType\XE164AltNum $member
     * @return \StructType\E164AltNum
     */
    public function setMember(\StructType\XE164AltNum $member = null)
    {
        $this->member = $member;
        return $this;
    }
}
