<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoUpdateRemoteClusterReq StructType
 * @subpackage Structs
 */
class DoUpdateRemoteClusterReq extends APIRequest
{
    /**
     * The server
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * @var string
     */
    public $server;
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * @var string
     */
    public $clusterId;
    /**
     * Constructor method for DoUpdateRemoteClusterReq
     * @uses DoUpdateRemoteClusterReq::setServer()
     * @uses DoUpdateRemoteClusterReq::setClusterId()
     * @param string $server
     * @param string $clusterId
     */
    public function __construct($server = null, $clusterId = null)
    {
        $this
            ->setServer($server)
            ->setClusterId($clusterId);
    }
    /**
     * Get server value
     * @return string|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @param string $server
     * @return \StructType\DoUpdateRemoteClusterReq
     */
    public function setServer($server = null)
    {
        // validation for constraint: string
        if (!is_null($server) && !is_string($server)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($server, true), gettype($server)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($server) && mb_strlen($server) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($server)), __LINE__);
        }
        $this->server = $server;
        return $this;
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\DoUpdateRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clusterId, true), gettype($clusterId)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($clusterId) && mb_strlen($clusterId) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
}
