<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ctiControlledDeviceProfiles StructType
 * @subpackage Structs
 */
class CtiControlledDeviceProfiles extends AbstractStructBase
{
    /**
     * The profileName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XFkType[]
     */
    public $profileName;
    /**
     * The deviceProfile
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $deviceProfile;
    /**
     * Constructor method for ctiControlledDeviceProfiles
     * @uses CtiControlledDeviceProfiles::setProfileName()
     * @uses CtiControlledDeviceProfiles::setDeviceProfile()
     * @param \StructType\XFkType[] $profileName
     * @param string[] $deviceProfile
     */
    public function __construct(array $profileName = array(), array $deviceProfile = array())
    {
        $this
            ->setProfileName($profileName)
            ->setDeviceProfile($deviceProfile);
    }
    /**
     * Get profileName value
     * @return \StructType\XFkType[]|null
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileNameForArrayConstraintsFromSetProfileName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ctiControlledDeviceProfilesProfileNameItem) {
            // validation for constraint: itemType
            if (!$ctiControlledDeviceProfilesProfileNameItem instanceof \StructType\XFkType) {
                $invalidValues[] = is_object($ctiControlledDeviceProfilesProfileNameItem) ? get_class($ctiControlledDeviceProfilesProfileNameItem) : sprintf('%s(%s)', gettype($ctiControlledDeviceProfilesProfileNameItem), var_export($ctiControlledDeviceProfilesProfileNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The profileName property can only contain items of type \StructType\XFkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set profileName value
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType[] $profileName
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function setProfileName(array $profileName = array())
    {
        // validation for constraint: array
        if ('' !== ($profileNameArrayErrorMessage = self::validateProfileNameForArrayConstraintsFromSetProfileName($profileName))) {
            throw new \InvalidArgumentException($profileNameArrayErrorMessage, __LINE__);
        }
        $this->profileName = $profileName;
        return $this;
    }
    /**
     * Add item to profileName value
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType $item
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function addToProfileName(\StructType\XFkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XFkType) {
            throw new \InvalidArgumentException(sprintf('The profileName property can only contain items of type \StructType\XFkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->profileName[] = $item;
        return $this;
    }
    /**
     * Get deviceProfile value
     * @return string[]|null
     */
    public function getDeviceProfile()
    {
        return $this->deviceProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceProfileForArrayConstraintsFromSetDeviceProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ctiControlledDeviceProfilesDeviceProfileItem) {
            // validation for constraint: itemType
            if (!is_string($ctiControlledDeviceProfilesDeviceProfileItem)) {
                $invalidValues[] = is_object($ctiControlledDeviceProfilesDeviceProfileItem) ? get_class($ctiControlledDeviceProfilesDeviceProfileItem) : sprintf('%s(%s)', gettype($ctiControlledDeviceProfilesDeviceProfileItem), var_export($ctiControlledDeviceProfilesDeviceProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The deviceProfile property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDeviceProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceProfile method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceProfileForMaxLengthConstraintFromSetDeviceProfile($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ctiControlledDeviceProfilesDeviceProfileItem) {
            // validation for constraint: maxLength(50)
            if (mb_strlen($ctiControlledDeviceProfilesDeviceProfileItem) > 50) {
                $invalidValues[] = var_export($ctiControlledDeviceProfilesDeviceProfileItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 50', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set deviceProfile value
     * @throws \InvalidArgumentException
     * @param string[] $deviceProfile
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function setDeviceProfile(array $deviceProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($deviceProfileArrayErrorMessage = self::validateDeviceProfileForArrayConstraintsFromSetDeviceProfile($deviceProfile))) {
            throw new \InvalidArgumentException($deviceProfileArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if ('' !== ($deviceProfileMaxLengthErrorMessage = self::validateDeviceProfileForMaxLengthConstraintFromSetDeviceProfile($deviceProfile))) {
            throw new \InvalidArgumentException($deviceProfileMaxLengthErrorMessage, __LINE__);
        }
        $this->deviceProfile = $deviceProfile;
        return $this;
    }
    /**
     * Add item to deviceProfile value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CtiControlledDeviceProfiles
     */
    public function addToDeviceProfile($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The deviceProfile property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (mb_strlen($item) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($item)), __LINE__);
        }
        $this->deviceProfile[] = $item;
        return $this;
    }
}
