<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for confidentialAccess StructType
 * @subpackage Structs
 */
class ConfidentialAccess extends AbstractStructBase
{
    /**
     * The confidentialAccessMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $confidentialAccessMode;
    /**
     * The confidentialAccessLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $confidentialAccessLevel;
    /**
     * Constructor method for confidentialAccess
     * @uses ConfidentialAccess::setConfidentialAccessMode()
     * @uses ConfidentialAccess::setConfidentialAccessLevel()
     * @param string $confidentialAccessMode
     * @param string $confidentialAccessLevel
     */
    public function __construct($confidentialAccessMode = null, $confidentialAccessLevel = null)
    {
        $this
            ->setConfidentialAccessMode($confidentialAccessMode)
            ->setConfidentialAccessLevel($confidentialAccessLevel);
    }
    /**
     * Get confidentialAccessMode value
     * @return string
     */
    public function getConfidentialAccessMode()
    {
        return $this->confidentialAccessMode;
    }
    /**
     * Set confidentialAccessMode value
     * @uses \EnumType\XCALMode::valueIsValid()
     * @uses \EnumType\XCALMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentialAccessMode
     * @return \StructType\ConfidentialAccess
     */
    public function setConfidentialAccessMode($confidentialAccessMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCALMode::valueIsValid($confidentialAccessMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCALMode', is_array($confidentialAccessMode) ? implode(', ', $confidentialAccessMode) : var_export($confidentialAccessMode, true), implode(', ', \EnumType\XCALMode::getValidValues())), __LINE__);
        }
        $this->confidentialAccessMode = $confidentialAccessMode;
        return $this;
    }
    /**
     * Get confidentialAccessLevel value
     * @return string
     */
    public function getConfidentialAccessLevel()
    {
        return $this->confidentialAccessLevel;
    }
    /**
     * Set confidentialAccessLevel value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentialAccessLevel
     * @return \StructType\ConfidentialAccess
     */
    public function setConfidentialAccessLevel($confidentialAccessLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($confidentialAccessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($confidentialAccessLevel) ? implode(', ', $confidentialAccessLevel) : var_export($confidentialAccessLevel, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->confidentialAccessLevel = $confidentialAccessLevel;
        return $this;
    }
}
