<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for codecsInList StructType
 * @subpackage Structs
 */
class CodecsInList extends AbstractStructBase
{
    /**
     * The codecNames
     * Meta information extracted from the WSDL
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var string[]
     */
    public $codecNames;
    /**
     * Constructor method for codecsInList
     * @uses CodecsInList::setCodecNames()
     * @param string[] $codecNames
     */
    public function __construct(array $codecNames = array())
    {
        $this
            ->setCodecNames($codecNames);
    }
    /**
     * Get codecNames value
     * @return string[]|null
     */
    public function getCodecNames()
    {
        return $this->codecNames;
    }
    /**
     * This method is responsible for validating the values passed to the setCodecNames method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodecNames method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodecNamesForArrayConstraintsFromSetCodecNames(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codecsInListCodecNamesItem) {
            // validation for constraint: itemType
            if (!is_string($codecsInListCodecNamesItem)) {
                $invalidValues[] = is_object($codecsInListCodecNamesItem) ? get_class($codecsInListCodecNamesItem) : sprintf('%s(%s)', gettype($codecsInListCodecNamesItem), var_export($codecsInListCodecNamesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The codecNames property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set codecNames value
     * @throws \InvalidArgumentException
     * @param string[] $codecNames
     * @return \StructType\CodecsInList
     */
    public function setCodecNames(array $codecNames = array())
    {
        // validation for constraint: array
        if ('' !== ($codecNamesArrayErrorMessage = self::validateCodecNamesForArrayConstraintsFromSetCodecNames($codecNames))) {
            throw new \InvalidArgumentException($codecNamesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($codecNames) && count($codecNames) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($codecNames)), __LINE__);
        }
        $this->codecNames = $codecNames;
        return $this;
    }
    /**
     * Add item to codecNames value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CodecsInList
     */
    public function addToCodecNames($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The codecNames property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->codecNames) && count($this->codecNames) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->codecNames)), __LINE__);
        }
        $this->codecNames[] = $item;
        return $this;
    }
}
