<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for certificates StructType
 * @subpackage Structs
 */
class Certificates extends AbstractStructBase
{
    /**
     * The certificate
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\XVpnGatewayMember[]
     */
    public $certificate;
    /**
     * Constructor method for certificates
     * @uses Certificates::setCertificate()
     * @param \StructType\XVpnGatewayMember[] $certificate
     */
    public function __construct(array $certificate = array())
    {
        $this
            ->setCertificate($certificate);
    }
    /**
     * Get certificate value
     * @return \StructType\XVpnGatewayMember[]|null
     */
    public function getCertificate()
    {
        return $this->certificate;
    }
    /**
     * This method is responsible for validating the values passed to the setCertificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertificate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertificateForArrayConstraintsFromSetCertificate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $certificatesCertificateItem) {
            // validation for constraint: itemType
            if (!$certificatesCertificateItem instanceof \StructType\XVpnGatewayMember) {
                $invalidValues[] = is_object($certificatesCertificateItem) ? get_class($certificatesCertificateItem) : sprintf('%s(%s)', gettype($certificatesCertificateItem), var_export($certificatesCertificateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The certificate property can only contain items of type \StructType\XVpnGatewayMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set certificate value
     * @throws \InvalidArgumentException
     * @param \StructType\XVpnGatewayMember[] $certificate
     * @return \StructType\Certificates
     */
    public function setCertificate(array $certificate = array())
    {
        // validation for constraint: array
        if ('' !== ($certificateArrayErrorMessage = self::validateCertificateForArrayConstraintsFromSetCertificate($certificate))) {
            throw new \InvalidArgumentException($certificateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($certificate) && count($certificate) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($certificate)), __LINE__);
        }
        $this->certificate = $certificate;
        return $this;
    }
    /**
     * Add item to certificate value
     * @throws \InvalidArgumentException
     * @param \StructType\XVpnGatewayMember $item
     * @return \StructType\Certificates
     */
    public function addToCertificate(\StructType\XVpnGatewayMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XVpnGatewayMember) {
            throw new \InvalidArgumentException(sprintf('The certificate property can only contain items of type \StructType\XVpnGatewayMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->certificate) && count($this->certificate) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->certificate)), __LINE__);
        }
        $this->certificate[] = $item;
        return $this;
    }
}
