<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applications StructType
 * Meta information extracted from the WSDL
 * - documentation: Read only
 * @subpackage Structs
 */
class Applications extends AbstractStructBase
{
    /**
     * The application
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $application;
    /**
     * Constructor method for applications
     * @uses Applications::setApplication()
     * @param string[] $application
     */
    public function __construct(array $application = array())
    {
        $this
            ->setApplication($application);
    }
    /**
     * Get application value
     * @return string[]|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * This method is responsible for validating the values passed to the setApplication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicationForArrayConstraintsFromSetApplication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationsApplicationItem) {
            // validation for constraint: itemType
            if (!is_string($applicationsApplicationItem)) {
                $invalidValues[] = is_object($applicationsApplicationItem) ? get_class($applicationsApplicationItem) : sprintf('%s(%s)', gettype($applicationsApplicationItem), var_export($applicationsApplicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The application property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setApplication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplication method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicationForMaxLengthConstraintFromSetApplication($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationsApplicationItem) {
            // validation for constraint: maxLength(50)
            if (mb_strlen($applicationsApplicationItem) > 50) {
                $invalidValues[] = var_export($applicationsApplicationItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 50', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set application value
     * @throws \InvalidArgumentException
     * @param string[] $application
     * @return \StructType\Applications
     */
    public function setApplication(array $application = array())
    {
        // validation for constraint: array
        if ('' !== ($applicationArrayErrorMessage = self::validateApplicationForArrayConstraintsFromSetApplication($application))) {
            throw new \InvalidArgumentException($applicationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if ('' !== ($applicationMaxLengthErrorMessage = self::validateApplicationForMaxLengthConstraintFromSetApplication($application))) {
            throw new \InvalidArgumentException($applicationMaxLengthErrorMessage, __LINE__);
        }
        $this->application = $application;
        return $this;
    }
    /**
     * Add item to application value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Applications
     */
    public function addToApplication($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The application property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (mb_strlen($item) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($item)), __LINE__);
        }
        $this->application[] = $item;
        return $this;
    }
}
