<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appUsers StructType
 * Meta information extracted from the WSDL
 * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
 * @subpackage Structs
 */
class AppUsers extends XCommonMembersExtension
{
    /**
     * The selectedAppUser
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectedAppUser[]
     */
    public $selectedAppUser;
    /**
     * Constructor method for appUsers
     * @uses AppUsers::setSelectedAppUser()
     * @param \StructType\SelectedAppUser[] $selectedAppUser
     */
    public function __construct(array $selectedAppUser = array())
    {
        $this
            ->setSelectedAppUser($selectedAppUser);
    }
    /**
     * Get selectedAppUser value
     * @return \StructType\SelectedAppUser[]|null
     */
    public function getSelectedAppUser()
    {
        return $this->selectedAppUser;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedAppUser method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedAppUser method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedAppUserForArrayConstraintsFromSetSelectedAppUser(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $appUsersSelectedAppUserItem) {
            // validation for constraint: itemType
            if (!$appUsersSelectedAppUserItem instanceof \StructType\SelectedAppUser) {
                $invalidValues[] = is_object($appUsersSelectedAppUserItem) ? get_class($appUsersSelectedAppUserItem) : sprintf('%s(%s)', gettype($appUsersSelectedAppUserItem), var_export($appUsersSelectedAppUserItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The selectedAppUser property can only contain items of type \StructType\SelectedAppUser, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set selectedAppUser value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedAppUser[] $selectedAppUser
     * @return \StructType\AppUsers
     */
    public function setSelectedAppUser(array $selectedAppUser = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedAppUserArrayErrorMessage = self::validateSelectedAppUserForArrayConstraintsFromSetSelectedAppUser($selectedAppUser))) {
            throw new \InvalidArgumentException($selectedAppUserArrayErrorMessage, __LINE__);
        }
        $this->selectedAppUser = $selectedAppUser;
        return $this;
    }
    /**
     * Add item to selectedAppUser value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedAppUser $item
     * @return \StructType\AppUsers
     */
    public function addToSelectedAppUser(\StructType\SelectedAppUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedAppUser) {
            throw new \InvalidArgumentException(sprintf('The selectedAppUser property can only contain items of type \StructType\SelectedAppUser, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->selectedAppUser[] = $item;
        return $this;
    }
}
