<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addRelatedPolicies StructType
 * @subpackage Structs
 */
class AddRelatedPolicies extends XCommonMembersExtension
{
    /**
     * The relatedPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XPolicyRelationship[]
     */
    public $relatedPolicy;
    /**
     * Constructor method for addRelatedPolicies
     * @uses AddRelatedPolicies::setRelatedPolicy()
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     */
    public function __construct(array $relatedPolicy = array())
    {
        $this
            ->setRelatedPolicy($relatedPolicy);
    }
    /**
     * Get relatedPolicy value
     * @return \StructType\XPolicyRelationship[]
     */
    public function getRelatedPolicy()
    {
        return $this->relatedPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedPolicyForArrayConstraintsFromSetRelatedPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addRelatedPoliciesRelatedPolicyItem) {
            // validation for constraint: itemType
            if (!$addRelatedPoliciesRelatedPolicyItem instanceof \StructType\XPolicyRelationship) {
                $invalidValues[] = is_object($addRelatedPoliciesRelatedPolicyItem) ? get_class($addRelatedPoliciesRelatedPolicyItem) : sprintf('%s(%s)', gettype($addRelatedPoliciesRelatedPolicyItem), var_export($addRelatedPoliciesRelatedPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatedPolicy property can only contain items of type \StructType\XPolicyRelationship, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     * @return \StructType\AddRelatedPolicies
     */
    public function setRelatedPolicy(array $relatedPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedPolicyArrayErrorMessage = self::validateRelatedPolicyForArrayConstraintsFromSetRelatedPolicy($relatedPolicy))) {
            throw new \InvalidArgumentException($relatedPolicyArrayErrorMessage, __LINE__);
        }
        $this->relatedPolicy = $relatedPolicy;
        return $this;
    }
    /**
     * Add item to relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship $item
     * @return \StructType\AddRelatedPolicies
     */
    public function addToRelatedPolicy(\StructType\XPolicyRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPolicyRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of type \StructType\XPolicyRelationship, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatedPolicy[] = $item;
        return $this;
    }
}
