<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unassign ServiceType
 * @subpackage Services
 */
class Unassign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named unassignPresenceUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnassignPresenceUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function unassignPresenceUser(\StructType\UnassignPresenceUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->unassignPresenceUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
